\name{pompe_c_score}
\alias{pompe_c_score}
\title{
POMPE-C Tool for Pulmonary Embolism Mortality in Cancer
}
\description{
Calculates the POMPE-C score to stratify the risk of 30-day all-cause mortality in patients with active cancer and acute symptomatic pulmonary embolism (PE). The score uses clinical variables including vital signs, physical exam findings, and do-not-resuscitate (DNR) status.
}
\usage{
pompe_c_score(altered_mental_status, dnr_status, oxygen_saturation, weight_kg,
              respiratory_rate, heart_rate, unilateral_leg_swelling)
}
\arguments{
  \item{altered_mental_status}{
Numeric (0 or 1). Presence of altered mental status (disorientation, stupor, coma). (1 = Yes, +18 pts).
}
  \item{dnr_status}{
Numeric (0 or 1). Do Not Resuscitate (DNR) status established. (1 = Yes, +13 pts).
}
  \item{oxygen_saturation}{
Numeric. Oxygen saturation on room air (\%). (< 90\% adds 8 pts).
}
  \item{weight_kg}{
Numeric. Body weight in kilograms. (< 70 kg adds 6 pts).
}
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute. (>= 24 bpm adds 6 pts).
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute. (>= 100 bpm adds 5 pts).
}
  \item{unilateral_leg_swelling}{
Numeric (0 or 1). Clinical signs of Deep Vein Thrombosis (unilateral leg swelling). (1 = Yes, -3 pts).
}
}
\value{
A list containing:
\item{POMPE_C_Score}{The calculated risk score (Range -3 to 56).}
\item{Risk_Category}{Classification (Low <= 5, Intermediate 6-19, High >= 20).}
\item{Est_30_Day_Mortality}{Estimated 30-day mortality percentage range based on derivation and validation cohorts.}
}
\references{
Sanchez O, Carmona L, Nieto JA, et al. Predicting 30-day mortality in patients with cancer and acute symptomatic pulmonary embolism: The POMPE-C tool. J Thromb Haemost. 2014;12(11):1833-1840. doi:10.1111/jth.12716
}
\examples{
# Example 1: High Risk
# DNR (1), SpO2 88%, Weight 60kg, HR 110
# Score = 13 + 8 + 6 + 5 = 32
pompe_c_score(0, 1, 88, 60, 20, 110, 0)

# Example 2: Low Risk
# No risk factors, Leg Swelling present
# Score = -3
pompe_c_score(0, 0, 98, 80, 16, 80, 1)
}
