\name{pittsburgh_response_endovascular_score}
\alias{pittsburgh_response_endovascular_score}
\title{
Pittsburgh Response to Endovascular Therapy (PRE) Score
}
\description{
Calculates the PRE Score to predict functional outcome at 90 days (defined as mRS 0-2) in patients with large vessel occlusion acute ischemic stroke undergoing endovascular therapy (thrombectomy). The score utilizes pre-procedure variables: Age, NIHSS, ASPECTS, and pre-stroke modified Rankin Scale.
}
\usage{
pittsburgh_response_endovascular_score(age, nihss_score, aspects_score, pre_stroke_mrs)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{nihss_score}{
Numeric. National Institutes of Health Stroke Scale score (0-42).
}
  \item{aspects_score}{
Numeric. Alberta Stroke Program Early CT Score (0-10).
}
  \item{pre_stroke_mrs}{
Numeric. Pre-stroke modified Rankin Scale (0-5).
}
}
\details{
\strong{Scoring System:}
\itemize{
  \item \strong{Age:} <60 (0), 60-69 (2), 70-79 (4), >=80 (6).
  \item \strong{NIHSS:} <10 (0), 10-15 (2), 16-20 (4), >=21 (6).
  \item \strong{ASPECTS:} 10 (0), 8-9 (2), <=7 (4).
  \item \strong{Pre-stroke mRS:} 0 (0), 1 (2), >=2 (4).
}
The total score ranges from 0 to 20. Lower scores correlate with higher probability of good functional outcome.
}
\value{
A list containing:
\item{PRE_Score}{The calculated total score.}
\item{Interpretation}{Prognostic implication regarding 90-day functional independence.}
}
\references{
Jadhav AP, et al. The Pittsburgh Response to Endovascular therapy (PRE) score: predicting functional outcome after endovascular therapy for acute ischemic stroke. J Neurointerv Surg. 2020.
}
\examples{
# Example 1: Good Prognosis Candidate
# Age 55 (0), NIHSS 12 (2), ASPECTS 10 (0), Pre-mRS 0 (0)
pittsburgh_response_endovascular_score(55, 12, 10, 0)

# Example 2: Poor Prognosis Candidate
# Age 82 (6), NIHSS 22 (6), ASPECTS 6 (4), Pre-mRS 3 (4)
pittsburgh_response_endovascular_score(82, 22, 6, 3)
}
