\name{pedis_diabetic_foot_score}
\alias{pedis_diabetic_foot_score}
\title{
PEDIS Score for Diabetic Foot Ulcers
}
\description{
Calculates the PEDIS Score to predict the 6-month risk of non-healing, amputation, or mortality in patients with diabetic foot ulcers. The score aggregates five domains: Perfusion, Extent (size), Depth, Infection, and Sensation.
}
\usage{
pedis_diabetic_foot_score(perfusion_grade, extent_cm2, depth_grade,
                          infection_grade, sensation_grade)
}
\arguments{
  \item{perfusion_grade}{
Numeric. IWGDF Perfusion Grade (1-3).
1: No PAD (Score 0).
2: PAD but no CLI (Score 1).
3: Critical Limb Ischemia (Score 2).
}
  \item{extent_cm2}{
Numeric. Area of the ulcer in cm^2.
0: Intact (Score 0).
<1 cm^2 (Score 1).
1-3 cm^2 (Score 2).
>3 cm^2 (Score 3).
}
  \item{depth_grade}{
Numeric. Depth of the ulcer.
0: Intact (Score 0).
1: Superficial (Score 1).
2: Fascia, muscle, or tendon (Score 2).
3: Bone or joint (Score 3).
}
  \item{infection_grade}{
Numeric. IWGDF Infection Grade (1-4).
1: None (Score 0).
2: Mild/Surface (Score 1).
3: Moderate/Abscess/Fasciitis (Score 2).
4: Severe/SIRS (Score 3).
}
  \item{sensation_grade}{
Numeric. Sensation status.
1: Intact (Score 0).
2: Loss of sensation (Score 1).
}
}
\value{
A list containing:
\item{PEDIS_Score}{The calculated total score (Range 0-12).}
\item{Risk_Assessment}{Interpretation of risk (High Risk >= 7).}
}
\references{
Chuan F, Tang K, Jiang P, et al. Reliability and validity of the perfusion, extent, depth, infection and sensation (PEDIS) classification system and score in patients with diabetic foot ulcer. PLoS One. 2015;10(4):e0124739. doi:10.1371/journal.pone.0124739
}
\examples{

# Example 1: High Risk
# PAD (2->1), >3cm2 (3), Deep (2), Moderate Infection (3->2), No Sensation (2->1)
# Score = 1 + 3 + 2 + 2 + 1 = 9
pedis_diabetic_foot_score(2, 4.0, 2, 3, 2)

# Example 2: Low Risk
# No PAD (1->0), <1cm2 (1), Superficial (1), No Infection (1->0), Intact Sensation (1->0)
# Score = 0 + 1 + 1 + 0 + 0 = 2
pedis_diabetic_foot_score(1, 0.5, 1, 1, 1)
}
