\name{pbsc_collection_volume}
\alias{pbsc_collection_volume}
\title{
Peripheral Blood Stem Cell (PBSC) Collection Volume Calculator
}
\description{
Calculates the total blood volume (in Liters) that must be processed through an apheresis machine to achieve a specific target yield of CD34+ stem cells. The calculation is based on the patient's weight, the pre-apheresis peripheral CD34+ cell count, and the estimated collection efficiency of the machine.
}
\usage{
pbsc_collection_volume(weight_kg, pre_cd34_count, target_yield,
                       collection_efficiency_percent = 50)
}
\arguments{
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
}
  \item{pre_cd34_count}{
Numeric. Peripheral blood CD34+ cell count (cells/uL or cells/mm^3).
}
  \item{target_yield}{
Numeric. The desired CD34+ cell yield in millions of cells per kg (x 10^6/kg). Common targets range from 2 to 5 x 10^6/kg.
}
  \item{collection_efficiency_percent}{
Numeric. The estimated efficiency of the apheresis machine in collecting CD34+ cells (0-100). Defaults to 50\%. Standard range is typically 30-50\%.
}
}
\details{
The formula used is:
\deqn{Volume (L) = \frac{Target Yield \times Weight}{CD34_{pre} \times Efficiency}}
Where:
\itemize{
  \item Target Yield is in \eqn{10^6} cells/kg
  \item \eqn{CD34_{pre}} is in cells/\eqn{\mu}L
  \item Efficiency is a decimal (Percent/100)
}
Note: The units cancel out such that the result is directly in Liters.
}
\value{
A list containing:
\item{Volume_to_Process_Liters}{The estimated blood volume to process to reach the target yield.}
}
\references{
Hester JP, et al. Stem Cell Collection. In: Apheresis: Principles and Practice. 3rd ed.
}
\examples{

# Example 1: Standard Collection
# 70kg patient, CD34 count 20/uL, Target 5 million/kg, 50% efficiency
# Vol = (5 * 70) / (20 * 0.5) = 350 / 10 = 35 Liters
pbsc_collection_volume(70, 20, 5, 50)

# Example 2: High Efficiency, Low Count
# 80kg, CD34 10/uL, Target 2 million/kg, 40% efficiency
# Vol = (2 * 80) / (10 * 0.4) = 160 / 4 = 40 Liters
pbsc_collection_volume(80, 10, 2, 40)
}
