\name{palchak_pediatric_head_trauma_rule}
\alias{palchak_pediatric_head_trauma_rule}
\title{
Palchak (UC Davis) Rule for Pediatric Head Trauma
}
\description{
Calculates the Palchak (UC Davis) Rule to identify children at low risk for traumatic brain injury (TBI) after blunt head trauma. The rule helps determine the need for head CT imaging. Children with none of the high-risk criteria are considered low risk and may be managed with observation.
}
\usage{
palchak_pediatric_head_trauma_rule(abnormal_mental_status,
                                   clinical_signs_skull_fracture,
                                   history_vomiting,
                                   scalp_hematoma_child_le_2y,
                                   headache)
}
\arguments{
  \item{abnormal_mental_status}{
Numeric (0 or 1). Is there abnormal mental status (e.g., GCS < 15, agitation, somnolence, slow response, repetitive questioning)? (1 = Yes).
}
  \item{clinical_signs_skull_fracture}{
Numeric (0 or 1). Are there clinical signs of skull fracture (e.g., palpable fracture, hemotympanum, raccoon eyes, Battle's sign, CSF leak)? (1 = Yes).
}
  \item{history_vomiting}{
Numeric (0 or 1). Is there a history of vomiting? (1 = Yes).
}
  \item{scalp_hematoma_child_le_2y}{
Numeric (0 or 1). Is there a scalp hematoma in a child aged 2 years or younger? (1 = Yes).
}
  \item{headache}{
Numeric (0 or 1). Is there a history of headache? (1 = Yes).
}
}
\value{
A list containing:
\item{Risk_Classification}{"High Risk" or "Low Risk".}
\item{Recommendation}{Clinical guidance regarding the need for CT imaging.}
}
\references{
Palchak MJ, Holmes JF, Vance CW, et al. A decision rule for identifying children at low risk for brain injuries after blunt head trauma. Ann Emerg Med. 2003;42(4):492-506. doi:10.1016/s0196-0644(03)00463-7
}
\examples{

# Example 1: Low Risk
# No symptoms or signs
palchak_pediatric_head_trauma_rule(0, 0, 0, 0, 0)

# Example 2: High Risk
# History of vomiting (1)
palchak_pediatric_head_trauma_rule(0, 0, 1, 0, 0)
}
