\name{ottawa_heart_failure_risk_scale}
\alias{ottawa_heart_failure_risk_scale}
\title{
Ottawa Heart Failure Risk Scale (OHFRS)
}
\description{
Calculates the Ottawa Heart Failure Risk Scale to predict the risk of serious adverse events (SAEs) within 14 days in patients with acute heart failure presenting to the emergency department. SAEs include death, admission to a monitored unit, intubation/NIV, MI, or relapse requiring admission.
}
\usage{
ottawa_heart_failure_risk_scale(stroke_tia_history, intubation_history,
                                heart_rate_arrival, oxygen_sat_arrival,
                                heart_rate_walk_test, ecg_ischemia, urea_mmol_l,
                                co2_mmol_l, troponin_elevated, nt_probnp)
}
\arguments{
  \item{stroke_tia_history}{
Numeric (0 or 1). History of Stroke or TIA. (1 = Yes, +1 point).
}
  \item{intubation_history}{
Numeric (0 or 1). History of intubation for respiratory distress. (1 = Yes, +2 points).
}
  \item{heart_rate_arrival}{
Numeric. Heart rate on ED arrival. (>= 110 bpm adds 2 points).
}
  \item{oxygen_sat_arrival}{
Numeric. Oxygen saturation on arrival (\%). (< 90\% adds 1 point).
}
  \item{heart_rate_walk_test}{
Numeric. Heart rate during 3-minute walk test (or enter >=110 if too ill to walk). (>= 110 bpm adds 1 point).
}
  \item{ecg_ischemia}{
Numeric (0 or 1). New ischemic changes on ECG. (1 = Yes, +2 points).
}
  \item{urea_mmol_l}{
Numeric. Serum Urea (BUN) level in mmol/L. (>= 12 mmol/L adds 1 point). Note: 12 mmol/L approx 33.6 mg/dL BUN.
}
  \item{co2_mmol_l}{
Numeric. Serum CO2 (Bicarbonate) level in mmol/L. (>= 35 mmol/L adds 2 points).
}
  \item{troponin_elevated}{
Numeric (0 or 1). Troponin I or T elevated to MI levels. (1 = Yes, +2 points).
}
  \item{nt_probnp}{
Numeric. NT-proBNP level in ng/L (pg/mL). (>= 5000 ng/L adds 1 point).
}
}
\value{
A list containing:
\item{OHFRS_Score}{The calculated risk score (Range 0-15).}
\item{Risk_Category}{Classification (Low, Moderate, High, Very High).}
\item{Risk_Serious_Adverse_Event_14d}{Estimated percentage probability of a serious adverse event within 14 days.}
}
\references{
Stiell IG, Clement CM, Brison RJ, et al. A risk scoring system to identify emergency department patients with heart failure at high risk for serious adverse events. Acad Emerg Med. 2013;20(1):17-26. doi:10.1111/acem.12056
Stiell IG, Perry JJ, Clement CM, et al. Prospective and Explicit Clinical Validation of the Ottawa Heart Failure Risk Scale, With and Without Use of Quantitative NT-proBNP. Acad Emerg Med. 2017;24(3):316-327. doi:10.1111/acem.13141
}
\examples{

# Example 1: High Risk
# Prior Intubation (+2), HR 115 (+2), Trop High (+2), Urea 15 (+1), NT-proBNP 6000 (+1)
# Score = 8
ottawa_heart_failure_risk_scale(0, 1, 115, 95, 80, 0, 15, 25, 1, 6000)

# Example 2: Low Risk
# No history, Vitals stable, Labs normal
# Score = 0
ottawa_heart_failure_risk_scale(0, 0, 80, 98, 85, 0, 5, 24, 0, 400)
}
