\name{orai_osteoporosis_score}
\alias{orai_osteoporosis_score}
\title{
Osteoporosis Risk Assessment Instrument (ORAI)
}
\description{
Calculates the ORAI score to identify postmenopausal women at increased risk for osteoporosis who should be selected for Bone Mineral Density (BMD) testing. The score assigns points based on age, weight, and current estrogen use.
}
\usage{
orai_osteoporosis_score(age, weight_kg, no_estrogen_therapy)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
>=75: 15 pts.
65-74: 9 pts.
55-64: 5 pts.
<55: 0 pts.
}
  \item{weight_kg}{
Numeric. Patient weight in kilograms.
<60 kg: 9 pts.
60-69 kg: 3 pts.
>=70 kg: 0 pts.
}
  \item{no_estrogen_therapy}{
Numeric (0 or 1). Is the patient NOT currently taking estrogen? (1 = Yes/No Estrogen, +2 pts).
}
}
\value{
A list containing:
\item{ORAI_Score}{The calculated risk score (Range 0-26).}
\item{Risk_Category}{Classification (Low Risk < 9, High Risk >= 9).}
\item{Recommendation}{Guidance regarding BMD testing.}
}
\references{
Cadarette SM, Jaglal SB, Kreiger N, McIsaac WJ, Darlington GA, Tu JV. Development and validation of the Osteoporosis Risk Assessment Instrument to facilitate selection of women for bone densitometry. CMAJ. 2000;162(9):1289-1294.
}
\examples{

# Example 1: High Risk
# 70yo (+9), 55kg (+9), No Estrogen (+2)
# Score = 20
orai_osteoporosis_score(70, 55, 1)

# Example 2: Low Risk
# 60yo (+5), 75kg (0), On Estrogen (0)
# Score = 5
orai_osteoporosis_score(60, 75, 0)
}
