\name{opioid_conversion_calculator}
\alias{opioid_conversion_calculator}
\title{
Opioid Conversion Calculator (Equianalgesic Dosing)
}
\description{
Calculates the equianalgesic dose when switching from one opioid to another. The function converts the input dose to Morphine Milligram Equivalents (MME) and then converts to the target opioid dose, applying an optional percentage reduction for incomplete cross-tolerance.
}
\usage{
opioid_conversion_calculator(current_drug, current_route, current_dose_mg,
                             target_drug, target_route, reduction_percent = 0)
}
\arguments{
  \item{current_drug}{
String. Name of the current opioid. Options: "morphine", "oxycodone", "hydrocodone", "hydromorphone", "codeine", "tramadol", "oxymorphone", "fentanyl".
}
  \item{current_route}{
String. Route of administration. Options: "po" (oral), "iv" (intravenous).
}
  \item{current_dose_mg}{
Numeric. The total dose of the current drug in milligrams. (Note: For Fentanyl IV, input must be in mg, e.g., 100 mcg = 0.1 mg).
}
  \item{target_drug}{
String. Name of the desired new opioid.
}
  \item{target_route}{
String. Route of the desired new opioid.
}
  \item{reduction_percent}{
Numeric. Percentage reduction to apply for incomplete cross-tolerance (e.g., 25 or 50). Defaults to 0.
}
}
\details{
Standard Equianalgesic Ratios used (relative to 1 mg PO Morphine):
Morphine PO: 1
Morphine IV: 3
Oxycodone PO: 1.5
Hydrocodone PO: 1
Hydromorphone PO: 4
Hydromorphone IV: 20
Codeine PO: 0.15
Tramadol PO: 0.1
Fentanyl IV: 300 (based on mg input)
}
\value{
A list containing:
\item{Morphine_Milligram_Equivalents}{The unreduced MME of the input dose.}
\item{Target_Dose_Calculated}{The estimated dose of the new drug after reduction.}
\item{Reduction_Applied}{The percentage reduction used.}
}
\references{
McPherson ML. Demystifying Opioid Conversion Calculations: A Guide for Effective Dosing. Amer Soc of Health System; 2010.
}
\examples{

# Example 1: 30mg PO Oxycodone to PO Morphine (No reduction)
# 30 * 1.5 = 45 MME
opioid_conversion_calculator("oxycodone", "po", 30, "morphine", "po")

# Example 2: 2mg IV Hydromorphone to PO Oxycodone with 25% reduction
# 2 * 20 = 40 MME. Reduce 25% = 30 MME. 30 / 1.5 = 20 mg Oxycodone.
opioid_conversion_calculator("hydromorphone", "iv", 2, "oxycodone", "po", 25)
}
