\name{nivo_score}
\alias{nivo_score}
\title{
NIVO Score for COPD Exacerbation
}
\description{
Calculates the Non-invasive Ventilation Outcomes (NIVO) score to predict in-hospital mortality in patients hospitalized with an acute exacerbation of COPD requiring non-invasive ventilation (NIV). The score is derived from the eMRCD dyspnea score, acidemia, chest radiograph findings, GCS, and presence of atrial fibrillation.
}
\usage{
nivo_score(emrcd_score, arterial_ph, consolidation_cxr, gcs_score,
           atrial_fibrillation)
}
\arguments{
  \item{emrcd_score}{
String. Extended MRC Dyspnea Score.
"1_4": Not housebound (0 points).
"5a": Housebound but independent washing/dressing (2 points).
"5b": Housebound and dependent for washing/dressing (4 points).
}
  \item{arterial_ph}{
Numeric. Arterial pH at initiation of NIV. (< 7.25 adds 2 points).
}
  \item{consolidation_cxr}{
Numeric (0 or 1). Presence of consolidation on Chest X-ray. (1 = Yes, +2 points).
}
  \item{gcs_score}{
Numeric. Glasgow Coma Scale score. (< 15 adds 2 points).
}
  \item{atrial_fibrillation}{
Numeric (0 or 1). Presence of Atrial Fibrillation (history or new). (1 = Yes, +1 point).
}
}
\value{
A list containing:
\item{NIVO_Score}{The calculated total score (Range 0-11).}
\item{Risk_Category}{Risk classification (Low to Highest).}
\item{In_Hospital_Mortality}{Estimated in-hospital mortality percentage.}
}
\references{
Hartley T, Lane ND, Steer J, et al. Predicting in-hospital mortality in patients with acute exacerbations of chronic obstructive pulmonary disease requiring non-invasive ventilation: the NIVO score. Thorax. 2021;76(8):777-783. doi:10.1136/thoraxjnl-2020-215841
}
\examples{

# Example 1: High Risk
# eMRCD 5b (4), pH 7.20 (2), No consolidation, GCS 15, No AF
# Score = 4 + 2 = 6
nivo_score("5b", 7.20, 0, 15, 0)

# Example 2: Low Risk
# eMRCD 1-4 (0), pH 7.30 (0), No consolidation, GCS 15, No AF
# Score = 0
nivo_score("1_4", 7.30, 0, 15, 0)
}
