\name{mcdonald_ms_criteria}
\alias{mcdonald_ms_criteria}
\title{
McDonald Criteria for Multiple Sclerosis (2017 Revision)
}
\description{
Evaluates the 2017 Revised McDonald Criteria for the diagnosis of Multiple Sclerosis (MS). Diagnosis relies on demonstrating Dissemination in Space (DIS) and Dissemination in Time (DIT). A key update in the 2017 revision is that the presence of CSF-specific oligoclonal bands can substitute for the requirement of DIT in patients with a typical clinically isolated syndrome (CIS).
}
\usage{
mcdonald_ms_criteria(clinical_attacks, clinical_lesions, dis_demonstrated,
                     dit_demonstrated, csf_oligoclonal_bands)
}
\arguments{
  \item{clinical_attacks}{
Numeric. Number of clinical attacks (relapses). (1 or >=2).
}
  \item{clinical_lesions}{
Numeric. Number of lesions with objective clinical evidence. (1 or >=2).
}
  \item{dis_demonstrated}{
Numeric (0 or 1). Dissemination in Space (DIS) demonstrated by MRI (>=1 T2 lesion in >=2 MS-typical regions: periventricular, cortical/juxtacortical, infratentorial, spinal cord). (1 = Yes).
}
  \item{dit_demonstrated}{
Numeric (0 or 1). Dissemination in Time (DIT) demonstrated by MRI (simultaneous presence of gadolinium-enhancing and non-enhancing lesions, or a new T2/enhancing lesion on follow-up). (1 = Yes).
}
  \item{csf_oligoclonal_bands}{
Numeric (0 or 1). Presence of CSF-specific oligoclonal bands. (1 = Yes). Note: Can substitute for DIT in the 2017 criteria for CIS.
}
}
\value{
A list containing:
\item{Diagnosis}{"Multiple Sclerosis (MS)" or "Possible MS / Clinically Isolated Syndrome (CIS)".}
\item{Missing_Requirements}{List of criteria still needed to confirm the diagnosis.}
}
\references{
Thompson AJ, Banwell BL, Barkhof F, et al. Diagnosis of multiple sclerosis: 2017 revisions of the McDonald criteria. Lancet Neurol. 2018;17(2):162-173. doi:10.1016/S1474-4422(17)30470-2
}
\examples{

# Example 1: 2 attacks, 1 clinical lesion, DIS on MRI
# Result: MS Diagnosed
mcdonald_ms_criteria(2, 1, 1, 0, 0)

# Example 2: CIS (1 attack, 1 lesion), DIS on MRI, No DIT on MRI, but CSF Positive
# Result: MS Diagnosed (CSF substitutes for DIT)
mcdonald_ms_criteria(1, 1, 1, 0, 1)

# Example 3: CIS (1 attack, 2 lesions), No DIT, No CSF
# Result: Possible MS (Missing DIT/CSF)
mcdonald_ms_criteria(1, 2, 0, 0, 0)
}
