\name{mayo_uc_score}
\alias{mayo_uc_score}
\title{
Mayo Score / Disease Activity Index (DAI) for Ulcerative Colitis
}
\description{
Calculates the Mayo Score (also known as the Disease Activity Index) for Ulcerative Colitis. This tool assesses disease severity based on four criteria: stool frequency, rectal bleeding, endoscopic findings, and the physician's global assessment.
}
\usage{
mayo_uc_score(stool_frequency, rectal_bleeding, endoscopic_findings,
              physician_global_assessment)
}
\arguments{
  \item{stool_frequency}{
Numeric (0-3). Stool frequency relative to normal.
0: Normal number of stools.
1: 1-2 stools more than normal.
2: 3-4 stools more than normal.
3: 5 or more stools more than normal.
}
  \item{rectal_bleeding}{
Numeric (0-3). Rectal bleeding.
0: No blood seen.
1: Streaks of blood with stool less than half the time.
2: Obvious blood with stool most of the time.
3: Blood alone passes.
}
  \item{endoscopic_findings}{
Numeric (0-3). Findings on endoscopy (flexible proctosigmoidoscopy).
0: Normal or inactive disease.
1: Mild disease (erythema, decreased vascular pattern, mild friability).
2: Moderate disease (marked erythema, lack of vascular pattern, friability, erosions).
3: Severe disease (spontaneous bleeding, ulceration).
}
  \item{physician_global_assessment}{
Numeric (0-3). Physician's Global Assessment.
0: Normal.
1: Mild disease.
2: Moderate disease.
3: Severe disease.
}
}
\value{
A list containing:
\item{Mayo_Score}{The calculated total score (Range 0-12).}
\item{Disease_Activity}{Interpretation of disease severity (Remission, Mild, Moderate, Severe).}
}
\references{
Schroeder KW, Tremaine WJ, Ilstrup DM. Coated oral 5-aminosalicylic acid therapy for mildly to moderately active ulcerative colitis. N Engl J Med. 1987;317(26):1625-1629. doi:10.1056/NEJM198712243172603
}
\examples{

# Example 1: Moderate Activity
# Freq +1 (1), Bleeding +1 (1), Endo Moderate (2), PGA Moderate (2)
# Score = 6
mayo_uc_score(1, 1, 2, 2)

# Example 2: Severe Activity
# Freq +3 (3), Blood alone (3), Endo Severe (3), PGA Severe (3)
# Score = 12
mayo_uc_score(3, 3, 3, 3)
}
