\name{ie_mortality_risk_score}
\alias{ie_mortality_risk_score}
\title{
Infective Endocarditis (IE) Mortality Risk Score
}
\description{
Calculates the 6-month mortality risk score for patients with active Infective Endocarditis (IE). Derived from the International Collaboration on Endocarditis (ICE) database, this tool stratifies patients into risk categories based on host factors, disease characteristics, and complications.
}
\usage{
ie_mortality_risk_score(age, severe_heart_failure, microorganism,
                        paravalvular_complication, dialysis, prosthetic_valve)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
<45: 0 pts.
45-54: 3 pts.
55-64: 5 pts.
65-74: 7 pts.
>=75: 9 pts.
}
  \item{severe_heart_failure}{
Numeric (0 or 1). Presence of severe heart failure (NYHA Class III or IV). (1 = Yes, +5 pts).
}
  \item{microorganism}{
String. Causative organism.
"viridans_streptococci": 0 pts.
"staphylococcus_aureus": +5 pts.
"other": +2 pts.
}
  \item{paravalvular_complication}{
Numeric (0 or 1). Presence of paravalvular complications (e.g., abscess, fistula). (1 = Yes, +4 pts).
}
  \item{dialysis}{
Numeric (0 or 1). Patient is on dialysis. (1 = Yes, +4 pts).
}
  \item{prosthetic_valve}{
Numeric (0 or 1). Presence of a prosthetic valve. (1 = Yes, +4 pts).
}
}
\value{
A list containing:
\item{IE_Mortality_Score}{The calculated risk score (Range 0-31+).}
\item{Risk_Category}{Classification (Low <=6, Intermediate 7-14, High >=15).}
\item{Est_6_Month_Mortality}{Estimated percentage probability of mortality within 6 months.}
}
\references{
Park LP, Chu VH, Peterson G, et al. A validated model for predicting 6-month mortality in infective endocarditis. Eur Heart J. 2016;37(30):2394-2404. doi:10.1093/eurheartj/ehv593
}
\examples{

# Example 1: High Risk
# 70yo (+7), S. aureus (+5), Dialysis (+4)
# Score = 16
ie_mortality_risk_score(70, 0, "staphylococcus_aureus", 0, 1, 0)

# Example 2: Low Risk
# 40yo (0), Viridans Strep (0), No complications
# Score = 0
ie_mortality_risk_score(40, 0, "viridans_streptococci", 0, 0, 0)
}
