\name{hat_score_tpa_hemorrhage}
\alias{hat_score_tpa_hemorrhage}
\title{
HAT Score for Predicting Post-tPA Hemorrhage
}
\description{
Calculates the HAT score to predict the risk of symptomatic intracranial hemorrhage (sICH) following thrombolysis with tPA for acute ischemic stroke. The score is based on four independent predictors: History of diabetes, Age (though age is not in the final simplified score, the acronym stands for Hemorrhage After Thrombolysis), Tpa-pretreatment glucose, and NIHSS score, plus identifiable hypodensity on initial CT.
}
\usage{
hat_score_tpa_hemorrhage(nihss_score, history_of_diabetes, glucose_mg_dl,
                         history_of_signs_of_early_infarct)
}
\arguments{
  \item{nihss_score}{
Numeric. Pre-treatment NIH Stroke Scale score. (<15: 0 pts, 15-20: 1 pt, >20: 2 pts).
}
  \item{history_of_diabetes}{
Numeric (0 or 1). History of diabetes mellitus. (1 = Yes, +1 pt).
}
  \item{glucose_mg_dl}{
Numeric. Pre-treatment glucose level in mg/dL. (>= 200 mg/dL adds 1 pt).
}
  \item{history_of_signs_of_early_infarct}{
Numeric (0 or 1). Evidence of early infarct signs on initial CT (e.g., hypodensity, loss of grey-white differentiation). (1 = Yes, +1 pt).
}
}
\value{
A list containing:
\item{HAT_Score}{The calculated score (Range 0-5).}
\item{Risk_Category}{Classification of risk (Low, Moderate, High, Very High).}
\item{Risk_of_Symptomatic_Intracranial_Hemorrhage}{Estimated percentage risk of sICH.}
}
\references{
Lou M, Safdar A, Mehdiratta M, et al. The HAT Score: a simple grading scale for predicting hemorrhage after thrombolysis. Neurology. 2008;71(18):1417-1423. doi:10.1212/01.wnl.0000330297.58383.35
}
\examples{

# Example 1: High Risk
# NIHSS 18 (+1), Diabetes (+1), Glucose 220 (+1), CT Signs (+1)
# Score = 4
hat_score_tpa_hemorrhage(18, 1, 220, 1)

# Example 2: Low Risk
# NIHSS 10 (0), No Diabetes, Glucose 100, No CT signs
# Score = 0
hat_score_tpa_hemorrhage(10, 0, 100, 0)
}
