\name{duke_activity_status_index}
\alias{duke_activity_status_index}
\title{
Duke Activity Status Index (DASI)
}
\description{
Calculates the Duke Activity Status Index (DASI), a self-administered questionnaire that measures a patient's functional capacity. The DASI score (0-58.2) correlates with peak oxygen uptake (VO2 peak), providing an estimate of cardiovascular fitness and functional reserve.
}
\usage{
duke_activity_status_index(self_care, walk_indoors, walk_blocks, climb_stairs,
                           run_short, light_housework, moderate_housework,
                           heavy_housework, yard_work, sexual_relations,
                           moderate_recreation, strenuous_sports)
}
\arguments{
  \item{self_care}{
Numeric (0 or 1). Can you take care of yourself (eat, dress, bathe, or use the toilet)?
}
  \item{walk_indoors}{
Numeric (0 or 1). Can you walk indoors, such as around your house?
}
  \item{walk_blocks}{
Numeric (0 or 1). Can you walk a block or two on level ground?
}
  \item{climb_stairs}{
Numeric (0 or 1). Can you climb a flight of stairs or walk up a hill?
}
  \item{run_short}{
Numeric (0 or 1). Can you run a short distance?
}
  \item{light_housework}{
Numeric (0 or 1). Can you do light work around the house like dusting or washing dishes?
}
  \item{moderate_housework}{
Numeric (0 or 1). Can you do moderate work around the house like vacuuming, sweeping floors, or carrying groceries?
}
  \item{heavy_housework}{
Numeric (0 or 1). Can you do heavy work around the house like scrubbing floors or lifting or moving heavy furniture?
}
  \item{yard_work}{
Numeric (0 or 1). Can you do yard work like raking leaves, weeding, or pushing a power mower?
}
  \item{sexual_relations}{
Numeric (0 or 1). Can you have sexual relations?
}
  \item{moderate_recreation}{
Numeric (0 or 1). Can you participate in moderate recreational activities like golf, bowling, dancing, doubles tennis, or throwing a baseball or football?
}
  \item{strenuous_sports}{
Numeric (0 or 1). Can you participate in strenuous sports like swimming, singles tennis, football, basketball, or skiing?
}
}
\value{
A list containing:
\item{DASI_Score}{The calculated DASI score (Range 0-58.2).}
\item{Estimated_VO2_Peak_mL_kg_min}{Estimated peak oxygen uptake.}
\item{Estimated_METs}{Estimated metabolic equivalents.}
}
\references{
Hlatky MA, Boineau RE, Higginbotham MB, et al. A brief self-administered questionnaire to determine functional capacity (the Duke Activity Status Index). Am J Cardiol. 1989;64(10):651-654. doi:10.1016/0002-9149(89)90496-7
}
\examples{

# Example 1: High Capacity
# Can do everything
duke_activity_status_index(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1)

# Example 2: Low Capacity
# Can only care for self and walk indoors
duke_activity_status_index(1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
}
