\name{dapt_score}
\alias{dapt_score}
\title{
Dual Antiplatelet Therapy (DAPT) Score
}
\description{
Calculates the DAPT Score to guide the duration of dual antiplatelet therapy (DAPT) after coronary stent implantation. The score balances the risks of ischemia (stent thrombosis, MI) against the risks of bleeding to determine if prolonged therapy (>12 months) is beneficial.
}
\usage{
dapt_score(age, smoker, diabetes, mi_presentation, prior_pci_mi,
           paclitaxel_stent, stent_diameter_lt_3mm, chf_lvef_lt_30,
           vein_graft_stent)
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
>= 75: -2 pts.
65-74: -1 pt.
< 65: 0 pts.
}
  \item{smoker}{
Numeric (0 or 1). Current cigarette smoker. (1 = Yes, +1 pt).
}
  \item{diabetes}{
Numeric (0 or 1). Diabetes mellitus. (1 = Yes, +1 pt).
}
  \item{mi_presentation}{
Numeric (0 or 1). MI at presentation. (1 = Yes, +1 pt).
}
  \item{prior_pci_mi}{
Numeric (0 or 1). Prior PCI or prior MI. (1 = Yes, +1 pt).
}
  \item{paclitaxel_stent}{
Numeric (0 or 1). Paclitaxel-eluting stent used. (1 = Yes, +1 pt).
}
  \item{stent_diameter_lt_3mm}{
Numeric (0 or 1). Stent diameter < 3 mm. (1 = Yes, +1 pt).
}
  \item{chf_lvef_lt_30}{
Numeric (0 or 1). Congestive heart failure or LVEF < 30\%. (1 = Yes, +2 pts).
}
  \item{vein_graft_stent}{
Numeric (0 or 1). Vein graft stent. (1 = Yes, +2 pts).
}
}
\value{
A list containing:
\item{DAPT_Score}{The calculated score (Range -2 to 10).}
\item{Risk_Profile}{"Low Score" (<2) or "High Score" (>=2).}
\item{Recommendation}{Clinical guidance regarding DAPT duration (Standard vs. Prolonged).}
}
\references{
Yeh RW, Secemsky EA, Kereiakes DJ, et al. Development and Validation of a Prediction Rule for Benefit and Harm of Dual Antiplatelet Therapy Beyond 1 Year After Percutaneous Coronary Intervention. JAMA. 2016;315(16):1735-1749. doi:10.1001/jama.2016.3775
}
\examples{

# Example 1: Prolonged DAPT Candidate
# 55yo (0), Smoker (+1), MI at presentation (+1), Diabetes (+1)
# Score = 3
dapt_score(55, 1, 1, 1, 0, 0, 0, 0, 0)

# Example 2: Standard DAPT Candidate
# 70yo (-1), Prior MI (+1), No other factors
# Score = 0
dapt_score(70, 0, 0, 0, 1, 0, 0, 0, 0)
}
