\name{copd_assessment_test}
\alias{copd_assessment_test}
\title{
COPD Assessment Test (CAT)
}
\description{
Calculates the COPD Assessment Test (CAT) score, an 8-item validated questionnaire designed to measure the overall impact of Chronic Obstructive Pulmonary Disease (COPD) on a patient's health and quality of life. Each item is scored on a 0 to 5 scale, yielding a total score from 0 to 40. The score is used in the GOLD assessment strategy.
}
\usage{
copd_assessment_test(cough, phlegm, chest_tightness, breathlessness_stairs,
                     activity_limitation, confidence_leaving_home, sleep, energy)
}
\arguments{
  \item{cough}{
Numeric (0-5). Score for coughing (0=Not at all, 5=Always).
}
  \item{phlegm}{
Numeric (0-5). Score for phlegm/mucus in chest (0=Not at all, 5=Always).
}
  \item{chest_tightness}{
Numeric (0-5). Score for chest tightness (0=Not at all, 5=Always).
}
  \item{breathlessness_stairs}{
Numeric (0-5). Score for breathlessness going up hills or stairs (0=Not at all, 5=Extremely).
}
  \item{activity_limitation}{
Numeric (0-5). Score for limitation of activities at home (0=Not at all, 5=Extremely).
}
  \item{confidence_leaving_home}{
Numeric (0-5). Score for confidence leaving home (0=Very confident, 5=Not at all confident).
}
  \item{sleep}{
Numeric (0-5). Score for sleep due to COPD symptoms (0=Not at all, 5=Always).
}
  \item{energy}{
Numeric (0-5). Score for energy level (0=Full of energy, 5=No energy).
}
}
\value{
A list containing:
\item{CAT_Score}{The calculated total score (Range 0-40).}
\item{Impact_Level}{Interpretation of the score: Low (<10), Medium (10-20), High (21-30), or Very High (> 30) impact.}
}
\references{
Jones PW, Harding G, Berry P, et al. Development and first validation of the COPD Assessment Test (CAT). Eur Respir J. 2009;34(3):648-654. doi:10.1183/09031936.00102509
}
\examples{

# Example 1: High Impact
# Mostly 4s and 5s
copd_assessment_test(5, 4, 4, 5, 5, 4, 4, 5)

# Example 2: Low Impact
# Mostly 0s and 1s
copd_assessment_test(1, 0, 0, 1, 0, 0, 0, 1)
}
