\name{ckd_epi_gfr}
\alias{ckd_epi_gfr}
\title{
CKD-EPI Equations for Glomerular Filtration Rate (GFR)
}
\description{
Calculates the Estimated Glomerular Filtration Rate (eGFR) using the CKD-EPI equations. This function includes the recommended 2021 Race-Free Creatinine equation, the 2021 Race-Free Creatinine-Cystatin C equation, the 2012 Cystatin C equation, and the older 2009 Race-Based Creatinine equation for comparison.
}
\usage{
ckd_epi_gfr(age, sex, creatinine, cystatin_c = NULL, race_black = FALSE,
            creatinine_units = "mg/dL", cystatin_units = "mg/L")
}
\arguments{
  \item{age}{
Numeric. Patient age in years.
}
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{creatinine}{
Numeric. Serum Creatinine level.
}
  \item{cystatin_c}{
Numeric (Optional). Serum Cystatin C level. Required for Cystatin-based equations.
}
  \item{race_black}{
Numeric or Logical (0/1 or FALSE/TRUE). Patient is Black/African American. Used only for the 2009 equation; ignored by 2021 equations.
}
  \item{creatinine_units}{
String. Units for Creatinine. Options: "mg/dL" (default) or "micromol/L" (or "umol/L").
}
  \item{cystatin_units}{
String. Units for Cystatin C. Options: "mg/L" (default).
}
}
\value{
A list containing:
\item{eGFR_2021_Creatinine}{The current standard race-free estimate (mL/min/1.73m^2).}
\item{eGFR_2021_Creatinine_Cystatin_C}{Combined race-free estimate (if Cystatin C provided).}
\item{eGFR_2012_Cystatin_C}{Cystatin C only estimate (if provided).}
\item{eGFR_2009_Creatinine}{The older race-based estimate.}
}
\references{
Inker LA, Eneanya ND, Coresh J, et al. New Creatinine- and Cystatin C-Based Equations to Estimate GFR Without Race. N Engl J Med. 2021;385:1737-1749. doi:10.1056/NEJMoa2102953
Levey AS, Stevens LA, Schmid CH, et al. A new equation to estimate glomerular filtration rate. Ann Intern Med. 2009;150(9):604-612.
}
\examples{

# Example 1: Standard 2021 Creatinine (No Race Input Needed)
# Female, 58, Cr 0.9 mg/dL
ckd_epi_gfr(58, "female", 0.9)

# Example 2: Combined Creatinine-Cystatin C
# Male, 65, Cr 1.2 mg/dL, CysC 0.9 mg/L
ckd_epi_gfr(65, "male", 1.2, 0.9)

# Example 3: 2009 Comparison (Black Race)
# Male, 50, Cr 1.5 mg/dL, Race Black
ckd_epi_gfr(50, "male", 1.5, race_black = TRUE)
}
