\name{cisne_score}
\alias{cisne_score}
\title{
Clinical Index of Stable Febrile Neutropenia (CISNE)
}
\description{
Calculates the CISNE score to predict the risk of serious complications (e.g., hypotension, organ failure, major bleeding) in patients with solid tumors presenting with apparently stable febrile neutropenia. This tool helps identify low-risk patients who may be candidates for outpatient management.
}
\usage{
cisne_score(ecog_ge_2, copd, cvd, mucositis_ge_2, monocytes_lt_200,
            stress_hyperglycemia)
}
\arguments{
  \item{ecog_ge_2}{
Numeric (0 or 1). ECOG Performance Status >= 2. (1 = Yes, +2 points).
}
  \item{copd}{
Numeric (0 or 1). Chronic Obstructive Pulmonary Disease. (1 = Yes, +1 point).
}
  \item{cvd}{
Numeric (0 or 1). Chronic Cardiovascular Disease (e.g., history of MI, heart failure). (1 = Yes, +1 point).
}
  \item{mucositis_ge_2}{
Numeric (0 or 1). Mucositis NCI Grade >= 2 (moderate to severe). (1 = Yes, +1 point).
}
  \item{monocytes_lt_200}{
Numeric (0 or 1). Monocytes < 200 per uL. (1 = Yes, +1 point).
}
  \item{stress_hyperglycemia}{
Numeric (0 or 1). Stress-induced hyperglycemia (defined as glucose > 120 mg/dL in absence of diabetes, or patient has history of diabetes). (1 = Yes, +2 points).
}
}
\value{
A list containing:
\item{CISNE_Score}{The calculated score (Range 0-8).}
\item{Risk_Class}{Classification (Low: 0, Intermediate: 1-2, High: >=3).}
\item{Est_Serious_Complication_Rate}{Estimated percentage risk of serious complications.}
\item{Recommendation}{Guidance on inpatient vs. outpatient management.}
}
\references{
Carmona-Bayonas A, Jiménez-Fonseca P, Virizuela Echaburu J, et al. Prediction of serious complications in patients with seemingly stable febrile neutropenia: validation of the Clinical Index of Stable Febrile Neutropenia (CISNE). J Clin Oncol. 2015;33(5):465-471. doi:10.1200/JCO.2014.57.2347
}
\examples{

# Example 1: High Risk
# ECOG 2 (+2), Diabetes/Hyperglycemia (+2)
# Score = 4
cisne_score(1, 0, 0, 0, 0, 1)

# Example 2: Low Risk
# No risk factors present
# Score = 0
cisne_score(0, 0, 0, 0, 0, 0)
}
