\name{calculate_edss}
\alias{calculate_edss}
\title{
Expanded Disability Status Scale (EDSS) Calculator
}
\description{
Calculates the EDSS score based on Kurtzke's Functional Systems Scores (FSS) and ambulation status. The scale ranges from 0.0 (normal) to 10.0 (death). Steps 0-4.5 are determined by FSS combinations, while steps 5.0-9.5 are defined primarily by impairment to ambulation.
}
\usage{
calculate_edss(pyramidal, cerebellar, brainstem, sensory, bowel_bladder,
               visual, cerebral, ambulation_code)
}
\arguments{
  \item{pyramidal}{Numeric (0-6). Pyramidal function score.}
  \item{cerebellar}{Numeric (0-5). Cerebellar function score.}
  \item{brainstem}{Numeric (0-5). Brainstem function score.}
  \item{sensory}{Numeric (0-6). Sensory function score.}
  \item{bowel_bladder}{Numeric (0-6). Bowel and Bladder function score.}
  \item{visual}{Numeric (0-6). Visual function score.}
  \item{cerebral}{Numeric (0-5). Cerebral (Mental) function score.}
  \item{ambulation_code}{
Numeric (0-11). Ambulation status code:
0: Unrestricted / Walks > 500m without aid.
1: Walks > 300m without aid (Step 4.5 range).
2: Walks > 200m without aid (Step 5.0 range).
3: Walks > 100m without aid (Step 5.5 range).
4: Unilateral assistance >= 100m (Step 6.0).
5: Bilateral assistance >= 20m (Step 6.5).
6: Restricted to wheelchair, can transfer/wheel self (Step 7.0).
7: Restricted to wheelchair, needs help transferring (Step 7.5).
8: Restricted to bed/chair, retains self-care (Step 8.0).
9: Restricted to bed, some effective arm use (Step 8.5).
10: Helpless bed patient, can communicate (Step 9.0).
11: Totally helpless, unable to communicate (Step 9.5).
}
}
\value{
A list containing:
\item{EDSS_Score}{The calculated Expanded Disability Status Scale score.}
\item{Inputs}{A record of the provided functional scores and ambulation status.}
}
\references{
Kurtzke JF. Rating neurologic impairment in multiple sclerosis: an expanded disability status scale (EDSS). Neurology. 1983;33(11):1444-1452. doi:10.1212/wnl.33.11.1444
}
\examples{

# Example 1: Mild Disability (Ambulatory)
# Pyramidal 2, others 0/1, Walks >500m
calculate_edss(2, 1, 0, 1, 0, 0, 0, 0)

# Example 2: Moderate Disability (Walking impaired)
# Pyramidal 3, Cerebellar 2, Walks 150m without aid
# Code 3 (>100m no aid) corresponds to 5.5
calculate_edss(3, 2, 1, 0, 1, 0, 0, 3)

# Example 3: Severe Disability (Wheelchair)
# Multiple high FSS, Wheelchair restricted (can transfer)
# Code 6 -> 7.0
calculate_edss(4, 3, 2, 3, 3, 1, 1, 6)
}
