\name{bush_francis_catatonia_scale}
\alias{bush_francis_catatonia_scale}
\title{
Bush-Francis Catatonia Rating Scale (BFCRS)
}
\description{
Calculates the total score for the Bush-Francis Catatonia Rating Scale, the standard instrument for diagnosing and assessing the severity of catatonia. It evaluates 23 items on a scale of 0 to 3. The first 14 items constitute the screening instrument; presence of 2 or more of these items warrants a full evaluation.
}
\usage{
bush_francis_catatonia_scale(excitement, immobility, mutism, staring, posturing,
                             grimacing, echophenomena, stereotypy, mannerisms,
                             verbigeration, rigidity, negativism, waxy_flexibility,
                             withdrawal, impulsivity, automatic_obedience, mitgehen,
                             gegenhalten, ambitendency, grasp_reflex, perseverance,
                             combativeness, autonomic_abnormality)
}
\arguments{
  \item{excitement}{Numeric (0-3). Extreme hyperactivity, constant motor unrest.}
  \item{immobility}{Numeric (0-3). Stupor, hypoactivity.}
  \item{mutism}{Numeric (0-3). Verbally unresponsive.}
  \item{staring}{Numeric (0-3). Fixed gaze, little or no blinking.}
  \item{posturing}{Numeric (0-3). Catalepsy, maintenance of posture.}
  \item{grimacing}{Numeric (0-3). Maintenance of odd facial expressions.}
  \item{echophenomena}{Numeric (0-3). Echopraxia or Echolalia.}
  \item{stereotypy}{Numeric (0-3). Repetitive, non-goal-directed movements.}
  \item{mannerisms}{Numeric (0-3). Odd, purposeful movements.}
  \item{verbigeration}{Numeric (0-3). Repetition of phrases or sentences.}
  \item{rigidity}{Numeric (0-3). Maintenance of position against resistance.}
  \item{negativism}{Numeric (0-3). Resistance to moving instructions.}
  \item{waxy_flexibility}{Numeric (0-3). Slight resistance to positioning.}
  \item{withdrawal}{Numeric (0-3). Refusal to eat/drink/interact.}
  \item{impulsivity}{Numeric (0-3). Sudden inappropriate behavior.}
  \item{automatic_obedience}{Numeric (0-3). Exaggerated cooperation.}
  \item{mitgehen}{Numeric (0-3). "Going with" body movements.}
  \item{gegenhalten}{Numeric (0-3). Resistance proportional to applied force.}
  \item{ambitendency}{Numeric (0-3). Motor indecision.}
  \item{grasp_reflex}{Numeric (0-3). Forced grasping.}
  \item{perseverance}{Numeric (0-3). Repetitive return to previous topic/movement.}
  \item{combativeness}{Numeric (0-3). Violence directed at others.}
  \item{autonomic_abnormality}{Numeric (0-3). Vital sign abnormalities.}
}
\value{
A list containing:
\item{BFCRS_Total_Score}{The sum of all 23 items (Range 0-69).}
\item{Screening_Result}{"Positive Screen" if >=2 of the first 14 items are present (>0).}
\item{Screening_Items_Present}{Count of positive screening items.}
}
\references{
Bush G, Fink M, Petrides G, Dowling F, Francis A. Catatonia. I. Rating scale and standardized examination. Acta Psychiatr Scand. 1996;93(2):129-36. doi:10.1111/j.1600-0447.1996.tb09814.x
}
\examples{

# Example 1: Positive Screen, High Severity
# Immobility(3), Mutism(3), Staring(2), Posturing(2), Rigidity(3)
# Others 0
bush_francis_catatonia_scale(0, 3, 3, 2, 2, 0, 0, 0, 0, 0, 3, 0, 0, 0,
                             0, 0, 0, 0, 0, 0, 0, 0, 0)

# Example 2: Negative Screen
# All 0
bush_francis_catatonia_scale(0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                             0, 0, 0, 0, 0, 0, 0, 0, 0)
}
