\name{asas_axial_spa}
\alias{asas_axial_spa}
\title{
ASAS Criteria for Axial Spondyloarthritis (SpA)
}
\description{
Applies the Assessment of SpondyloArthritis international Society (ASAS) classification criteria for axial spondyloarthritis. These criteria are applicable to patients with back pain for >= 3 months and age of onset < 45 years. Classification is achieved through either the "Imaging Arm" (Sacroiliitis + >=1 SpA feature) or the "Clinical Arm" (HLA-B27 + >=2 other SpA features).
}
\usage{
asas_axial_spa(back_pain_gt_3mo, age_onset_lt_45, sacroiliitis_imaging, hla_b27,
               inflammatory_bp, arthritis, enthesitis_heel, uveitis, dactylitis,
               psoriasis, crohns_colitis, good_nsaid_response, family_history_spa,
               elevated_crp_esr)
}
\arguments{
  \item{back_pain_gt_3mo}{
Numeric (0 or 1). Back pain duration >= 3 months. (Entry Criterion).
}
  \item{age_onset_lt_45}{
Numeric (0 or 1). Age at onset of back pain < 45 years. (Entry Criterion).
}
  \item{sacroiliitis_imaging}{
Numeric (0 or 1). Active (acute) inflammation on MRI highly suggestive of sacroiliitis associated with SpA, OR definite radiographic sacroiliitis according to modified New York criteria.
}
  \item{hla_b27}{
Numeric (0 or 1). Positive HLA-B27 status.
}
  \item{inflammatory_bp}{
Numeric (0 or 1). History of inflammatory back pain.
}
  \item{arthritis}{
Numeric (0 or 1). Arthritis (past or present).
}
  \item{enthesitis_heel}{
Numeric (0 or 1). Enthesitis (heel).
}
  \item{uveitis}{
Numeric (0 or 1). Uveitis (past or present).
}
  \item{dactylitis}{
Numeric (0 or 1). Dactylitis (past or present).
}
  \item{psoriasis}{
Numeric (0 or 1). Psoriasis (past or present).
}
  \item{crohns_colitis}{
Numeric (0 or 1). Crohn's disease or ulcerative colitis (past or present).
}
  \item{good_nsaid_response}{
Numeric (0 or 1). Good response to NSAIDs (back pain relief within 24-48h).
}
  \item{family_history_spa}{
Numeric (0 or 1). Family history for SpA (in first- or second-degree relative).
}
  \item{elevated_crp_esr}{
Numeric (0 or 1). Elevated CRP or ESR (after exclusion of other causes).
}
}
\value{
A list containing:
\item{Classification}{"Classified as Axial Spondyloarthritis", "Not Classified", or "Not Applicable".}
\item{Criteria_Arm_Met}{Indicates if the patient met the "Imaging Arm", "Clinical Arm", or "Both".}
}
\references{
Rudwaleit M, van der Heijde D, Landewé R, et al. The development of Assessment of SpondyloArthritis international Society classification criteria for axial spondyloarthritis (part II): validation and final selection. Ann Rheum Dis. 2009;68(6):777-783. doi:10.1136/ard.2009.108233
}
\examples{

# Example 1: Imaging Arm
# Entry criteria met, Sacroiliitis present, Inflammatory BP present
asas_axial_spa(1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0)

# Example 2: Clinical Arm
# Entry criteria met, No imaging findings, HLA-B27 Positive,
# Uveitis present, Family History present (2 clinical features)
asas_axial_spa(1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0)
}
