\name{ais_inhalation}
\alias{ais_inhalation}
\title{
Abbreviated Injury Score (AIS) for Inhalation Injury
}
\description{
Retrieves the classification and estimated mortality risk for the Abbreviated Injury Score (AIS) for Inhalation Injury. This scoring system grades the severity of inhalation injury based on bronchoscopic findings, ranging from Grade 0 (No injury) to Grade 4 (Massive injury).
}
\usage{
ais_inhalation(grade)
}
\arguments{
  \item{grade}{
Numeric. The bronchoscopic grade of injury (0, 1, 2, 3, or 4).
}
}
\value{
A list containing:
\item{Grade}{The input grade.}
\item{Classification}{Description of the bronchoscopic findings associated with the grade.}
\item{Estimated_Mortality}{Approximate mortality risk associated with the grade, based on Endorf and Gamelli (2007).}
}
\references{
Endorf FW, Gamelli RL. Inhalation injury, pulmonary complications, and mortality. J Burn Care Res. 2007;28(1):80-83. doi:10.1097/BCR.0B013E31802C889F
}
\examples{

# Example 1: Moderate Injury
# Patient with moderate erythema and carbonaceous deposits
ais_inhalation(2)

# Example 2: Massive Injury
# Patient with mucosal sloughing and necrosis
ais_inhalation(4)
}
