\name{airq_asthma_score}
\alias{airq_asthma_score}
\title{
Asthma Impairment and Risk Questionnaire (AIRQ)
}
\description{
Calculates the AIRQ score, a 10-item, yes/no questionnaire designed to assess asthma control in patients aged 12 years and older. It evaluates both current impairment (past 2 weeks) and future risk (past 12 months). The total score stratifies patients into Well-controlled, Not well-controlled, or Very poorly controlled categories.
}
\usage{
airq_asthma_score(symptoms_gt_4days, awakening_gt_1time, activity_limited_daily,
                  rescue_inhaler_daily, social_limited, exercise_limited,
                  difficult_control, oral_steroids_12mo, er_visit_12mo,
                  hospital_overnight_12mo)
}
\arguments{
  \item{symptoms_gt_4days}{
Numeric (0 or 1). In the past 2 weeks, did symptoms bother you during the day on more than 4 days? (1 = Yes).
}
  \item{awakening_gt_1time}{
Numeric (0 or 1). In the past 2 weeks, did symptoms wake you up from sleep more than 1 time? (1 = Yes).
}
  \item{activity_limited_daily}{
Numeric (0 or 1). In the past 2 weeks, did symptoms limit the activities you wanted to do every day? (1 = Yes).
}
  \item{rescue_inhaler_daily}{
Numeric (0 or 1). In the past 2 weeks, did symptoms cause you to use your rescue inhaler or nebulizer every day? (1 = Yes).
}
  \item{social_limited}{
Numeric (0 or 1). In the past 2 weeks, did you have to limit your social activities because of your asthma? (1 = Yes).
}
  \item{exercise_limited}{
Numeric (0 or 1). In the past 2 weeks, did symptoms limit your ability to exercise? (1 = Yes).
}
  \item{difficult_control}{
Numeric (0 or 1). In the past 2 weeks, did you feel that it was difficult to control your asthma? (1 = Yes).
}
  \item{oral_steroids_12mo}{
Numeric (0 or 1). In the past 12 months, did symptoms cause you to take steroid pills or shots (e.g., prednisone)? (1 = Yes).
}
  \item{er_visit_12mo}{
Numeric (0 or 1). In the past 12 months, did symptoms cause you to go to the ER or have unplanned visits? (1 = Yes).
}
  \item{hospital_overnight_12mo}{
Numeric (0 or 1). In the past 12 months, did symptoms cause you to stay in the hospital overnight? (1 = Yes).
}
}
\value{
A list containing:
\item{AIRQ_Score}{The total number of affirmative answers (Range 0-10).}
\item{Control_Level}{Interpretation: "Well-controlled" (0-1), "Not well-controlled" (2-4), or "Very poorly controlled" (5-10).}
\item{Exacerbation_Risk}{Projected risk of exacerbation in the next year based on the control level.}
}
\references{
Murphy KR, et al. Development of the Asthma Impairment and Risk Questionnaire (AIRQ): A Composite Control Measure. J Allergy Clin Immunol Pract. 2020;8(7):2263-2274.e5. doi:10.1016/j.jaip.2020.02.042
}
\examples{

# Example 1: Very Poorly Controlled
# Symptoms >4 days, Waking >1, Exercise limited, Felt difficult to control, Steroids used
# Score = 5
airq_asthma_score(1, 1, 0, 0, 0, 1, 1, 1, 0, 0)

# Example 2: Well-Controlled
# No symptoms or history of exacerbations
# Score = 0
airq_asthma_score(0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
}
