\name{acute_pancreatitis_prediction_model}
\alias{acute_pancreatitis_prediction_model}
\title{
Acute Pancreatitis Prediction Model
}
\description{
Calculates a prediction score for the likelihood of acute pancreatitis in patients presenting with elevated lipase. A score of 6 or greater suggests a high probability of acute pancreatitis, helping to differentiate it from other causes of hyperlipasemia.
}
\usage{
acute_pancreatitis_prediction_model(prior_episodes, cholelithiasis, recent_surgery,
                                    epigastric_pain, worsening_severity,
                                    pain_duration_days, pain_severity_score,
                                    lipase_uln_multiplier)
}
\arguments{
  \item{prior_episodes}{
Numeric. Number of prior acute pancreatitis episodes.
(0-1 = 0 pts; 2 = +2 pts; 3 = +3 pts; >=4 = +4 pts).
}
  \item{cholelithiasis}{
Numeric (0 or 1). History of cholelithiasis (gallstones). (1 = Yes, +2 pts).
}
  \item{recent_surgery}{
Numeric (0 or 1). Abdominal surgery within the prior 2 months. (1 = Yes, -2 pts).
}
  \item{epigastric_pain}{
Numeric (0 or 1). Presence of epigastric pain. (1 = Yes, +2 pts).
}
  \item{worsening_severity}{
Numeric (0 or 1). Is the pain worsening in severity? (1 = Yes, +1 pt).
}
  \item{pain_duration_days}{
Numeric. Duration of pain in days. (1-5 days = +1 pt; otherwise 0).
}
  \item{pain_severity_score}{
Numeric. Pain severity on a scale of 0-10.
(0-3 = 0 pts; 4-6 = +2 pts; 7-10 = +3 pts).
}
  \item{lipase_uln_multiplier}{
Numeric. Serum lipase level expressed as a multiple of the Upper Limit of Normal (ULN).
(3 to <10 = 0 pts; 10 to <20 = +1 pt; >=20 = +2 pts).
}
}
\value{
A list containing:
\item{Total_Score}{The calculated prediction score.}
\item{Risk_Assessment}{"Low Risk" or "High Probability" based on the cutoff of 6.}
}
\references{
Jang DK, et al. Development and Validation of a Prediction Model for Acute Pancreatitis in Patients with Elevated Serum Lipase. Sci Rep. 2019.
}
\examples{

# Example 1: High Probability
# No prior eps, Stones present (+2), No surgery, Epigastric pain (+2),
# Worsening (+1), 2 days duration (+1), Severe pain (+3), Lipase 25x (+2)
# Score = 2 + 2 + 1 + 1 + 3 + 2 = 11
acute_pancreatitis_prediction_model(0, 1, 0, 1, 1, 2, 8, 25)

# Example 2: Low Risk
# 1 prior ep (0), No stones, Recent surgery (-2), No epigastric pain,
# Not worsening, 10 days duration (0), Mild pain (0), Lipase 5x (0)
# Score = -2
acute_pancreatitis_prediction_model(1, 0, 1, 0, 0, 10, 2, 5)
}
