\name{abuse_assessment_screen}
\alias{abuse_assessment_screen}
\title{
Abuse Assessment Screen (AAS)
}
\description{
Implements the Abuse Assessment Screen (AAS), a 5-item screening tool designed to detect domestic abuse (intimate partner violence) in pregnant and non-pregnant women in healthcare settings. It assesses emotional, physical, and sexual abuse, as well as fear of a partner.
}
\usage{
abuse_assessment_screen(ever_abused, past_year_physically_hurt,
                        forced_sexual_activities, afraid_of_partner,
                        pregnant_and_hurt = 0)
}
\arguments{
  \item{ever_abused}{
Numeric (0 or 1). Question 1: "Have you ever been emotionally or physically abused by your partner or someone important to you?" (1 = Yes, 0 = No).
}
  \item{past_year_physically_hurt}{
Numeric (0 or 1). Question 2: "Within the last year, have you been hit, slapped, kicked, or otherwise physically hurt by someone?" (1 = Yes, 0 = No).
}
  \item{forced_sexual_activities}{
Numeric (0 or 1). Question 3: "Within the last year, has anyone forced you to have sexual activities?" (1 = Yes, 0 = No).
}
  \item{afraid_of_partner}{
Numeric (0 or 1). Question 4: "Are you afraid of your partner or anyone you listed above?" (1 = Yes, 0 = No).
}
  \item{pregnant_and_hurt}{
Numeric (0 or 1). Question 5 (If applicable): "Since you've been pregnant, have you been slapped, kicked, or otherwise physically hurt by someone?" (1 = Yes, 0 = No). Defaults to 0 if not pregnant or not applicable.
}
}
\value{
A list containing:
\item{Screen_Result}{"Positive" or "Negative".}
\item{Interpretation}{Clinical interpretation of the result.}
\item{Recommendation}{Suggested clinical actions based on the screen.}
\item{Questions_Affirmed}{A list indicating which specific questions were answered affirmatively.}
}
\references{
McFarlane J, Parker B, Soeken K, Bullock L. Assessing for abuse during pregnancy. Severity and frequency of injuries and associated entry into prenatal care. JAMA. 1992;267(23):3176-3178.
}
\examples{

# Example 1: Positive Screen
# Patient reports being afraid of partner
abuse_assessment_screen(0, 0, 0, 1, 0)

# Example 2: Negative Screen
# No affirmative answers
abuse_assessment_screen(0, 0, 0, 0, 0)
}
