% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_observations.R
\name{compare_observations}
\alias{compare_observations}
\title{Compare Observations of Two Datasets}
\usage{
compare_observations(df1, df2, tolerance = 0)
}
\arguments{
\item{df1}{A data frame representing the first dataset.}

\item{df2}{A data frame representing the second dataset.}

\item{tolerance}{Numeric tolerance value for floating-point comparisons (default 0).
When tolerance > 0, numeric values are considered equal if their absolute
difference is within the tolerance threshold. Character and factor columns
always use exact matching regardless of tolerance.}
}
\value{
A list containing discrepancy counts and details of row differences.
}
\description{
Performs row-by-row comparison of two datasets on common columns, identifying
specific value differences at the cell level. Returns discrepancy counts and details
showing which rows differ and how their values diverge.
}
\examples{
\donttest{
  df1 <- data.frame(id = 1:3, value = c(1.0, 2.0, 3.0))
  df2 <- data.frame(id = 1:3, value = c(1.0, 2.5, 3.0))
  compare_observations(df1, df2)
  compare_observations(df1, df2, tolerance = 0.00001)
}
}
