% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clc.R
\name{as_raster}
\alias{as_raster}
\alias{as_raster.clc}
\title{Convert a `clc` Object to Raster Format}
\usage{
as_raster(clo, base_raster, resolution)

\method{as_raster}{clc}(clo, base_raster = NULL, resolution = NULL)
}
\arguments{
\item{clo}{A `clc` object.}

\item{base_raster}{(Optional) A raster object to use as the base for rasterization.}

\item{resolution}{(Optional) Numeric resolution to define the raster grid.}
}
\value{
An object of class `clc_raster`.
}
\description{
Returns an object of class `clc_raster` that contains a `terra::SpatRaster` raster
object representing the converted vector layer into raster format.
}
\details{
The function requires either `base_raster` or `resolution` to be provided.
If both are missing, an error is raised.
}
\examples{
source_gpkg <- system.file("extdata", "clc.gpkg", package = "clc")
clo <- clc(source = source_gpkg, layer_name = "clc")

raster_path <- system.file("extdata", "mdt.tif", package = "clc")
base_raster <- terra::rast(raster_path)

# ex1
r <- clo |>
     as_raster(base_raster = base_raster)

# ex2
r <- clo |>
     as_raster(resolution = 50)

}
\seealso{
Other CLC class functions: 
\code{\link{clc}()},
\code{\link{copy_to}()},
\code{\link{cut_to_extent}()},
\code{\link{get_colors.clc}()},
\code{\link{get_levels.clc}()},
\code{\link{get_raster}()},
\code{\link{plot_clc}()},
\code{\link{prepare_plot}()},
\code{\link{save_to}()}
}
\concept{CLC class functions}
