% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cits_plot.R
\name{plot_cits_result}
\alias{plot_cits_result}
\title{CITS Automatic Analysis and Visualization}
\usage{
plot_cits_result(
  res,
  y_col = "y",
  T_col = "T",
  E_col = "E",
  intervention_time = NULL
)
}
\arguments{
\item{res}{A list returned by `cits()`, containing model output and fitted values.}

\item{y_col}{Name of the outcome variable (string). Corresponds to `y` in `cits()`.}

\item{T_col}{Name of the time index variable (string). Corresponds to `T` in `cits()`.}

\item{E_col}{Name of the group indicator variable (string). Corresponds to `E` in `cits()`.}

\item{intervention_time}{Optional numeric. If provided, a vertical dashed line is drawn
at this time to mark the intervention point.}
}
\value{
A ggplot object showing observed points, fitted lines, confidence ribbons,
        and (optionally) the intervention line.
}
\description{
Visualizes the results of a controlled interrupted time series (CITS) model
fitted using `cits()`. The function plots observed data points, fitted values,
and 95% confidence intervals. An optional vertical intervention line can also be added.
}
\examples{
# Synthetic example
df <- data.frame(
  T = 1:100,
  E = rep(c(0,1), each = 100),
  I = c(rep(0,50), rep(1,50), rep(0,50), rep(1,50)),
  y = rnorm(200)
)

# Use lightweight ARMA search for examples (CRAN speed requirement)
res <- cits(
  df,
  y_col = "y",
  T_col = "T",
  I_col = "I",
  E_col = "E",
  p_range = 0:1,
  q_range = 0:0
)

plot_cits_result(res)

}
