% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choice_parameters.R
\name{choice_parameters}
\alias{choice_parameters}
\alias{generate_choice_parameters}
\alias{validate_choice_parameters}
\alias{switch_parameter_space}
\title{Define choice model parameters}
\usage{
choice_parameters(beta = NULL, Omega = NULL, Sigma = NULL, gamma = NULL)

generate_choice_parameters(
  choice_effects,
  fixed_parameters = choice_parameters()
)

validate_choice_parameters(
  choice_parameters,
  choice_effects,
  allow_missing = FALSE
)

switch_parameter_space(choice_parameters, choice_effects)
}
\arguments{
\item{beta}{[\code{numeric(P)}]\cr
The coefficient vector of length \code{P} (number of effects) for computing the
linear-in-parameters systematic utility \eqn{V = X\beta}.}

\item{Omega}{[\code{matrix(nrow = P_r, ncol = P_r)} | \code{NULL}]\cr
The covariance matrix of random effects of dimension \code{P_r} times \code{P_r},
where \code{P_r} \eqn{\leq} \code{P} is the number of random effects.

Can be \code{NULL} in the case of \code{P_r = 0}.}

\item{Sigma}{[\code{matrix(nrow = J, ncol = J)} | \code{numeric(1)}]\cr
Only relevant in the probit model. For unordered alternatives it is the
covariance matrix of dimension \code{J} times \code{J} (number of alternatives) for
the Gaussian error term \eqn{\epsilon = U - V}. In ordered models it reduces
to a single variance term.}

\item{gamma}{[\code{numeric(J - 1)} | \code{NULL}]\cr
Optional vector of strictly increasing threshold parameters for ordered
models. The first element must equal zero for identification. Ignored for
unordered alternatives.}

\item{choice_effects}{[\code{choice_effects}]\cr
A \code{\link{choice_effects}} object describing the utility
specification.}

\item{fixed_parameters}{[\code{choice_parameters}]\cr
Optionally a \code{choice_parameters} object of parameters to keep
fixed when sampling other parameters.}

\item{choice_parameters}{[\code{choice_parameters}]\cr
A \code{choice_parameters} object.}

\item{allow_missing}{[\code{logical(1)}]\cr
Should parameters be allowed to be missing (\code{TRUE}) or must all required
elements be present (\code{FALSE})?}
}
\value{
An object of class \code{choice_parameters}, which is a \code{list} with the elements:
\describe{
\item{\code{beta}}{The coefficient vector (if any).}
\item{\code{Omega}}{The covariance matrix of random effects (if any).}
\item{\code{Sigma}}{The error term covariance matrix (or variance in ordered
models).}
\item{\code{gamma}}{Threshold parameters for ordered models (if any).}
}
}
\description{
These functions construct, validate, and transform an object of class
\code{choice_parameters}, which defines the parameters of a choice model.
\itemize{
\item \code{choice_parameters()} constructs a \code{choice_parameters} object.
\item \code{generate_choice_parameters()} samples parameters at random, see details.
\item \code{validate_choice_parameters()} validates a \code{choice_parameters} object.
\item \code{switch_parameter_space()} transforms a \code{choice_parameters} object between
the interpretation and optimization space, see details.
}
}
\section{Sampling missing choice model parameters}{


Unspecified choice model parameters (if required) are drawn
independently from the following distributions:
\describe{
\item{\code{beta}}{Drawn from a multivariate normal distribution with zero
mean and a diagonal covariance matrix with value 10 on the diagonal.}
\item{\code{Omega}}{Drawn from an Inverse-Wishart distribution with degrees
of freedom equal to \code{P_r} + 2 and scale matrix equal to the identity.}
\item{\code{Sigma}}{The first row and column are fixed to 0 for level
normalization. The \eqn{(2, 2)}-value is fixed to 1 for scale
normalization. The lower right block is drawn from an Inverse-Wishart
distribution with degrees of freedom equal to \code{J} + 1 and scale matrix
equal to the identity.}
}
}

\section{Parameter spaces}{


The \code{switch_parameter_space()} function transforms a \code{choice_parameters}
object between the interpretation and optimization space.
\itemize{
\item The interpretation space is a \code{list} of (not necessarily identified)
parameters that can be interpreted.
\item The optimization space is a \code{numeric} vector of identified parameters that
can be optimized:
\itemize{
\item \code{beta} is not transformed
\item the first row and column of \code{Sigma} are fixed to 0 for level
normalization and the second diagonal element is fixed to 1 for scale
normalization
\item the covariance matrices (\code{Omega} and \code{Sigma}) are transformed to their
vectorized Cholesky factor (diagonal fixed to be positive for uniqueness)
}
}
}

\examples{
### generate choice parameters at random
J <- 3
choice_effects <- choice_effects(
  choice_formula = choice_formula(
    formula = choice ~ A | B, error_term = "probit",
    random_effects = c("A" = "cn")
  ),
  choice_alternatives = choice_alternatives(J = J)
)
choice_parameters <- generate_choice_parameters(
  choice_effects = choice_effects,
  fixed_parameters = choice_parameters(
    Sigma = diag(c(0, rep(1, J - 1))) # scale and level normalization
  )
)
}
\keyword{model}
