% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge-data.R
\name{merge_rec_data}
\alias{merge_rec_data}
\title{Merge recoded data}
\usage{
merge_rec_data(...)
}
\arguments{
\item{...}{recoded data frames to be merged.}
}
\value{
a merged data frame consisting of multiple recoded CCHS cycles with
 labels for variable names and tags for variables not included in particular
 CCHS cycles.
}
\description{
This function allows users to merge CCHS data transformed by the
 \code{\link{rec_with_table}} function. This function generates a labelled
 merged data frame with multiple transformed CCHS cycles.
}
\details{
When merging recoded CCHS data, there are variables that are missing
 in certain CCHS cycles. This function tags missing variable observations as
 NA(c), indicating that the variable was not asked or included in the CCHS
 cycle of the respondent. 
 
 Click \href{https://big-life-lab.github.io/cchsflow/articles/tagged_na_usage.html}{here}
 for more details on how NA's are treated in cchsflow.
}
\examples{
# Merging two CCHS cycles with variables missing in each cycle.

# INCGHH_A is a cchsflow variable available for the 2001 CCHS cycle, while
# INCGHH_B is a cchsflow variable available for the 2003 CCHS cycle. 
# Using merge_rec_data(), datasets containing INCGHH_A & INCGHH_B can be
# merged and tagged.

library(cchsflow)
income2001 <- rec_with_table(cchs2001_p, "INCGHH_A")
income2003 <- rec_with_table(cchs2001_p, "INCGHH_B")

income_merged <- merge_rec_data(income2001, income2003)
head(income_merged)
tail(income_merged)

}
