% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{g1_score}
\alias{g1_score}
\title{G1 score}
\usage{
g1_score(truth, est, type = c("adj", "dir"))
}
\arguments{
\item{truth}{A \link[caugi:caugi]{caugi::caugi} object representing the truth graph.}

\item{est}{A \link[caugi:caugi]{caugi::caugi} object representing the estimated graph.}

\item{type}{Character string specifying the comparison type:
\itemize{
\item \code{"adj"}: adjacency comparison.
\item \code{"dir"}: orientation comparison conditional on shared adjacencies.
}}
}
\value{
A numeric in [0,1].
}
\description{
Computes G1 score from two \link[caugi:caugi]{caugi::caugi} objects.
It converts the \link[caugi:caugi]{caugi::caugi} objects to adjacency matrices and computes
G1 score defined as \eqn{2 \cdot TN/(2 \cdot TN + FN + FP)}, where \code{TN} are truth negatives,
\code{FP} are false positives, and FN are false negatives. If \code{TN + FN + FP = 0}, \code{1} is returned.
Only supports \link[caugi:caugi]{caugi::caugi} objects with these edge types present \verb{-->}, \verb{<-->}, \verb{---} and no edge.
}
\examples{
cg1 <- caugi::caugi(A \%-->\% B + C)
cg2 <- caugi::caugi(B \%-->\% A + C)
g1_score(cg1, cg2, type = "adj")
g1_score(cg1, cg2, type = "dir")

}
\references{
Petersen, Anne Helby, et al. "Causal discovery for observational sciences using
supervised machine learning." arXiv preprint arXiv:2202.12813 (2022).
}
\seealso{
Other metrics: 
\code{\link{confusion}()},
\code{\link{evaluate}()},
\code{\link{f1_score}()},
\code{\link{false_omission_rate}()},
\code{\link{fdr}()},
\code{\link{npv}()},
\code{\link{precision}()},
\code{\link{recall}()},
\code{\link{reexports}},
\code{\link{specificity}()}
}
\concept{metrics}
