% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knowledge.R
\name{deparse_knowledge}
\alias{deparse_knowledge}
\title{Deparse a Knowledge Object into Knowledge DSL Code}
\usage{
deparse_knowledge(kn, df_name = NULL)
}
\arguments{
\item{kn}{A \code{Knowledge} object.}

\item{df_name}{Optional name of the data frame you used
(used as the first argument to \code{knowledge()}).  If \code{NULL},
\code{knowledge()} is called with no data frame.}
}
\value{
A single string (with newlines) of R code.
}
\description{
Given a \code{Knowledge} object, return a single string containing
the R code (using \code{knowledge()}, \code{tier()}, \verb{\%-->\%}, and \verb{\%!-->\%}.
that would rebuild that same object.
}
\examples{
# turn a Knowledge object back into DSL code
data(tpc_example)

kn <- knowledge(
  tpc_example,
  tier(
    child ~ starts_with("child"),
    youth ~ starts_with("youth"),
    old ~ starts_with("old")
  ),
  child_x1 \%-->\% youth_x3,
  oldage_x6 \%!-->\% child_x1
)

code <- deparse_knowledge(kn, df_name = "tpc_example")
cat(code)

# Explicitly add all forbidden edges implied by tiers
kn <- convert_tiers_to_forbidden(kn)
code <- deparse_knowledge(kn, df_name = "tpc_example")
cat(code)
}
\seealso{
Other knowledge functions: 
\code{\link{+.Knowledge}()},
\code{\link{add_exogenous}()},
\code{\link{add_tier}()},
\code{\link{add_to_tier}()},
\code{\link{add_vars}()},
\code{\link{as_bnlearn_knowledge}()},
\code{\link{as_pcalg_constraints}()},
\code{\link{as_tetrad_knowledge}()},
\code{\link{convert_tiers_to_forbidden}()},
\code{\link{forbid_edge}()},
\code{\link{get_tiers}()},
\code{\link{knowledge}()},
\code{\link{knowledge_to_caugi}()},
\code{\link{remove_edge}()},
\code{\link{remove_tiers}()},
\code{\link{remove_vars}()},
\code{\link{reorder_tiers}()},
\code{\link{reposition_tier}()},
\code{\link{require_edge}()},
\code{\link{seq_tiers}()},
\code{\link{unfreeze}()}
}
\concept{knowledge}
\concept{knowledge functions}
