% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knowledge-conversions.R
\name{as_pcalg_constraints}
\alias{as_pcalg_constraints}
\title{Convert Knowledge to pcalg Knowledge}
\usage{
as_pcalg_constraints(kn, labels = kn$vars$var, directed_as_undirected = FALSE)
}
\arguments{
\item{kn}{A \code{knowledge} object.  Must have no tier information.}

\item{labels}{Character vector of all variable names, in the exact order
of your data columns.  Every variable referenced by an edge in \code{kn}
must appear here.}

\item{directed_as_undirected}{Logical (default \code{FALSE}).  If
\code{FALSE}, we require that every edge in \code{kn} has its
mirror-image present as well, and will error if any are missing.  If
\code{TRUE}, we automatically mirror every directed edge into
an undirected constraint.}
}
\value{
A list with two elements, each an \code{n × n} logical matrix
corresponding to \pkg{pcalg} \code{fixed_gaps} and \code{fixed_edges} arguments.
}
\description{
\pkg{pcalg} only supports \emph{undirected} (symmetric) background constraints:
\itemize{
\item \strong{fixed_gaps}  - forbidding edges (zeros enforced)
\item \strong{fixed_edges} - requiring edges (ones enforced)
}
}
\details{
This function takes a \code{knowledge} object (with only forbidden/required
edges, no tiers) and returns the two logical matrices in the exact
variable order you supply.
}
\section{Errors}{

\itemize{
\item If the \code{Knowledge} object contains tiered knowledge.
\item If \code{directed_as_undirected = FALSE} and any edge lacks its
symmetrical counterpart. This can only hold for forbidden edges.
}
}

\examples{
# pcalg supports undirected constraints; build a tierless knowledge and convert
data(tpc_example)

kn <- knowledge(
  tpc_example,
  child_x1 \%!-->\% youth_x3,
  youth_x3 \%!-->\% child_x1
)

pc_constraints <- as_pcalg_constraints(kn, directed_as_undirected = FALSE)
print(pc_constraints)

# error paths
# using tiers
kn <- knowledge(
  tpc_example,
  tier(
    child ~ starts_with("child"),
    youth ~ starts_with("youth"),
    oldage ~ starts_with("old")
  ),
  child_x1 \%-->\% youth_x3
)

try(as_pcalg_constraints(kn), silent = TRUE) # fails due to tiers

# using directed knowledge
kn <- knowledge(
  tpc_example,
  child_x1 \%!-->\% youth_x3
)

try(as_pcalg_constraints(kn), silent = TRUE) # fails due to directed knowledge
}
\seealso{
Other knowledge functions: 
\code{\link{+.Knowledge}()},
\code{\link{add_exogenous}()},
\code{\link{add_tier}()},
\code{\link{add_to_tier}()},
\code{\link{add_vars}()},
\code{\link{as_bnlearn_knowledge}()},
\code{\link{as_tetrad_knowledge}()},
\code{\link{convert_tiers_to_forbidden}()},
\code{\link{deparse_knowledge}()},
\code{\link{forbid_edge}()},
\code{\link{get_tiers}()},
\code{\link{knowledge}()},
\code{\link{knowledge_to_caugi}()},
\code{\link{remove_edge}()},
\code{\link{remove_tiers}()},
\code{\link{remove_vars}()},
\code{\link{reorder_tiers}()},
\code{\link{reposition_tier}()},
\code{\link{require_edge}()},
\code{\link{seq_tiers}()},
\code{\link{unfreeze}()}
}
\concept{knowledge}
\concept{knowledge functions}
