% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeTree.R
\name{makeTree}
\alias{makeTree}
\title{Make Tree of Possible Question Combinations}
\usage{
makeTree(catObj, flat = FALSE)
}
\arguments{
\item{catObj}{An object of class \code{Cat}}

\item{flat}{A logical indicating whether to return tree as as a list of lists or a table}
}
\value{
The function \code{makeTree} returns either a list or a table.  If the argument \code{flat} is \code{FALSE}, the default value, the function returns a list of lists.

If the argument \code{flat} is \code{TRUE}, the function takes the list of lists and configures it into a flattened table where the columns represent the battery items and the rows represent the possible answer profiles.
}
\description{
Pre-calculates a complete branching scheme of all possible questions-answer combinations and stores it as a list of lists or a flattened table of values.
}
\details{
The function takes a \code{Cat} object and generates a tree of all possible question-answer combinations, conditional on previous answers in the branching scheme and the current \eqn{\theta} estimates for the branch.
The tree is stored as a list of lists, iteratively generated by filling in a possible answer, calculating the next question via \code{selectItem}, filling in a possible answer for that question, and so forth.

The length of each complete branching scheme within the tree is dictated by the \code{lengthThreshold} slot within the \code{Cat} object.
}
\note{
This function is computationally expensive.  If there are \eqn{k} response options and the researcher wants a complete branching scheme to include \eqn{n} items, \eqn{k^{n-1}} complete branching schemes will be calculated.  Setting \eqn{n} is done via the \code{lengthThreshold} slot in the \code{Cat} object.  See \strong{Examples}.

This function is to allow users to access the internal functions of the package. During item selection, all calculations are done in compiled \code{C++} code.
}
\examples{
## Loading ltm Cat object
data(ltm_cat)

## Setting complete branches to include 3 items
setLengthThreshold(ltm_cat) <- 3

## Object returned is list of lists
ltm_list <- makeTree(ltm_cat)

## Object returned is table
ltm_table <- makeTree(ltm_cat, flat = TRUE)




}
\seealso{
\code{\link{Cat-class}}, \code{\link{checkStopRules}}, \code{\link{selectItem}}
}
\author{
Haley Acevedo, Ryden Butler, Josh W. Cutler, Matt Malis, Jacob M. Montgomery, Tom Wilkinson, Erin Rossiter, Min Hee Seo, Alex Weil
}
