% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outcome_models.R
\name{outcome_shared}
\alias{outcome_shared}
\title{Outcome model}
\arguments{
\item{data}{(data.table) Covariate data, usually the output of the covariate
model of a \link{Trial} object.}

\item{par}{(numeric) Regression coefficients (default zero). Can be given as
a named list corresponding to the column names of \code{model.matrix}}

\item{outcome.name}{Name of outcome variable ("y")}

\item{remove}{Variables that will be removed from input \code{data} (if formula is
not specified).}

\item{mean}{(formula, function) Either a formula specifying the design from
'data' or a function that maps \code{data} to the conditional mean value on the
link scale (see examples). If NULL all main-effects of the covariates will
be used, except columns that are defined via the \code{remove} argument.}

\item{...}{Additional arguments passed to \code{mean} function (see examples)}
}
\value{
data.table
}
\description{
Outcome model
}
