% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branching.R
\name{gen_expbranches}
\alias{gen_expbranches}
\title{Generate data with exponential shaped branches}
\usage{
gen_expbranches(n = 400, p = 4, k = 4, noise_fun = gen_noisedims, ...)
}
\arguments{
\item{n}{A numeric value (default: 400) representing the sample size.}

\item{p}{A numeric value (default: 4) representing the number of dimensions.}

\item{k}{A numeric value (default: 4) representing the number of branches.}

\item{noise_fun}{A function specifying which noise generation function to
use for the additional dimensions. Default is \code{gen_noisedims}. Other options include \code{gen_wavydims1}, \code{gen_wavydims2}, and \code{gen_wavydims3}.}

\item{...}{Additional arguments passed to the selected \code{noise_fun}
(e.g., \code{m}, \code{s}, \code{theta}, \code{x1_vec}, \code{data}).}
}
\value{
A data containing exponential shaped branches.
}
\description{
This function generates a dataset representing a structure with exponential shaped branches.
}
\examples{
set.seed(20240412)
expbranches <- gen_expbranches(n = 400, p = 4, k = 4,
noise_fun = gen_noisedims, m = rep(0, 2), s = rep(0.1, 2))
}
