% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{save_svg}
\alias{save_svg}
\title{Save SVG string to file (sanitized + embedded fonts)}
\usage{
save_svg(svg_content, output_path)
}
\arguments{
\item{svg_content}{SVG string (or object coercible to character).}

\item{output_path}{Output file path.}
}
\value{
Path to the saved SVG file.
}
\description{
Saves an SVG string to disk. Before saving, the function:
\enumerate{
\item sanitizes the SVG to remove problematic Inkscape/Sodipodi metadata that can
break strict XML parsers, and
\item detects and embeds fonts (WOFF2 via @font-face) for deterministic rendering.
}

This function expects the font helpers to be available in the package:
\code{detect_svg_fonts()}, \code{ensure_cardargus_fonts()}, and \code{embed_svg_fonts()}.
}
\examples{
svg <- svg_card("FAR", list(), list())
save_svg(svg, tempfile(fileext = ".svg"))

}
