% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.R
\name{capr.boot}
\alias{capr.boot}
\title{Bootstrap confidence intervals for CAP coefficients}
\usage{
capr.boot(
  fit,
  nboot = 1000L,
  level = 0.95,
  max_iter = 100L,
  tol = 1e-06,
  seed = NULL
)
}
\arguments{
\item{fit}{A \code{\link{capr}} fit containing components \code{B} and \code{Gamma}.}

\item{nboot}{Integer; number of bootstrap replicates.}

\item{level}{Confidence level for the returned intervals.}

\item{max_iter}{Maximum Newton iterations for solving \eqn{\beta}.}

\item{tol}{Convergence tolerance for the Newton solver.}

\item{seed}{Optional integer seed for reproducibility.}
}
\value{
A list of class \code{capr.boot} with:
\item{beta}{bootstrap average of \eqn{\beta} with dimension \eqn{q \times K}}
\item{ci_lower, ci_upper}{Matrices \eqn{q \times K} with the lower/upper
confidence limits.}
\item{level}{The requested confidence level.}
}
\description{
Generates bootstrap inference for the CAP regression coefficients while
holding the fitted directions \eqn{\Gamma} fixed. Each replicate samples the
covariance slices \eqn{S[, , i]} with replacement, projects them onto the fixed
directions to obtain component-specific variances, and re-solves the
\eqn{\beta^{(k)}} equations. Quantile-based confidence intervals are returned
for every predictor/component pair.
}
\examples{
simu.data <- simu.capr(seed = 123L, n = 120L)
K <- 3L
fit <- capr(
    S = simu.data$S,
    X = simu.data$X,
    K = K
)
capr.boot(fit, nboot = 10L, level = 0.95, seed = 42L)
}
