% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_model.R, R/class_model_ANCCR.R,
%   R/class_model_HDI2020.R, R/class_model_HD2022.R, R/class_model_MAC1975.R,
%   R/class_model_PKH1982.R, R/class_model_RAND.R, R/class_model_RW1972.R,
%   R/class_model_SM2007.R, R/class_model_TD.R
\name{CalmrModel-methods}
\alias{CalmrModel-methods}
\alias{run,CalmrModel-method}
\alias{run}
\alias{parameters,CalmrModel-method}
\alias{parameters<-,CalmrModel-method}
\alias{raw_results,CalmrModel-method}
\alias{parsed_results,CalmrModel-method}
\alias{show,CalmrModel-method}
\alias{parse,CalmrModel-method}
\alias{plot,CalmrModel-method}
\alias{graph,CalmrModel-method}
\alias{run,ANCCR-method}
\alias{run,HDI2020-method}
\alias{run,HD2022-method}
\alias{run,MAC1975-method}
\alias{run,PKH1982-method}
\alias{run,RAND-method}
\alias{run,RW1972-method}
\alias{run,SM2007-method}
\alias{run,TD-method}
\title{CalmrModel methods}
\usage{
\S4method{run}{CalmrModel}(object, experience, mapping, timings, ...)

\S4method{parameters}{CalmrModel}(x)

\S4method{parameters}{CalmrModel}(x) <- value

\S4method{raw_results}{CalmrModel}(object)

\S4method{parsed_results}{CalmrModel}(object)

\S4method{show}{CalmrModel}(object)

\S4method{parse}{CalmrModel}(object, outputs = object@outputs)

\S4method{plot}{CalmrModel}(x, type = NULL, ...)

\S4method{graph}{CalmrModel}(x, ...)

\S4method{run}{ANCCR}(object, experience, mapping, timings, ..., debug = FALSE, debug_t = -1)

\S4method{run}{HDI2020}(object, experience, mapping, ...)

\S4method{run}{HD2022}(object, experience, mapping, ...)

\S4method{run}{MAC1975}(object, experience, mapping, ...)

\S4method{run}{PKH1982}(object, experience, mapping, ...)

\S4method{run}{RAND}(object, experience, mapping, ...)

\S4method{run}{RW1972}(object, experience, mapping, ...)

\S4method{run}{SM2007}(
  object,
  experience,
  mapping,
  debug = FALSE,
  comparator_func = .witnauer_comparator_proc,
  ...
)

\S4method{run}{TD}(object, experience, mapping, timings, ...)
}
\arguments{
\item{object}{A \linkS4class{CalmrModel} object.}

\item{experience}{A data.frame specifying trials as rows,
as returned by \code{make_experiment()}.}

\item{mapping}{A named list specifying trial and stimulus mapping,
as returned by \code{make_experiment()}.}

\item{timings}{A named list specifying timings for the model. Only used
for timed models.}

\item{...}{Additional named arguments.}

\item{x}{A \linkS4class{CalmrModel} object.}

\item{value}{A list of parameters to set.}

\item{outputs}{A character vector specifying the outputs to parse.
If not specified, all outputs of the model will be parsed.}

\item{type}{A character vector specifying the
types of plots to generate (should be model outputs).}

\item{debug}{A logical to print debugging messages.}

\item{debug_t}{A trial to debug at.}

\item{comparator_func}{The function for the comparator process.}
}
\value{
\code{run()} returns the \linkS4class{CalmrModel} after
running the phases in the design.

\code{parameters()} returns the parameters
of the \linkS4class{CalmrModel} object.

\verb{parameters()<-} sets the parameters of a \linkS4class{CalmrModel} object.

\code{raw_results()} returns the last
raw results of the \linkS4class{CalmrModel} object.

\code{parsed_results()} returns the last
parsed results of the \linkS4class{CalmrModel} object.

\code{show()} returns NULL (invisibly).

\code{parse()} returns \linkS4class{CalmrModel} with parsed results.

\code{plot()} returns a list of 'ggplot' plot objects.

\code{graph()} returns a 'ggplot' object.
}
\description{
S4 methods for \linkS4class{CalmrModel}
}
\note{
The \code{run} method changes some internal
states of the model (if appropriate) and
populates the \code{.last_raw_results} slot with the results of the run.
}
