% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tournament_rules.R
\name{top_per_group}
\alias{top_per_group}
\title{Select top ranked participants per group}
\usage{
top_per_group(n)
}
\arguments{
\item{n}{Positive integer count per group.}
}
\value{
A \code{bracketeer_selector} object.
}
\description{
Select top ranked participants per group
}
\examples{
# World Cup style: 8 groups, top 2 per group advance
teams <- paste("Team", sprintf("\%02d", 1:32))
trn <- tournament(teams) |>
  round_robin("groups", groups = 8) |>
  single_elim("knockout", take = top_per_group(2))
}
