% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tournament_spec.R
\name{split_stage}
\alias{split_stage}
\title{Add multiple transitions from one source stage}
\usage{
split_stage(
  spec,
  from,
  into,
  priority_start = 1L,
  consume = TRUE,
  allow_overlap = FALSE,
  seeding = "by_source_rank"
)
}
\arguments{
\item{spec}{A \code{tournament_spec} object.}

\item{from}{Source stage ID, or \code{from_previous()}.}

\item{into}{Named list mapping destination stage IDs to transition rules, or
branch configs with a required \code{rule} field.}

\item{priority_start}{Starting priority for branch transitions when a branch
does not explicitly provide \code{priority}.}

\item{consume}{Default \code{consume} value for branches.}

\item{allow_overlap}{Default \code{allow_overlap} value for branches.}

\item{seeding}{Default seeding policy for branches.}
}
\value{
Updated \code{tournament_spec}.
}
\description{
Convenience sugar for branching stage fan-out. Compiles into deterministic
\code{add_transition()} calls.
}
