% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/landau_distribution.R
\name{landau_distribution}
\alias{landau_distribution}
\alias{landau_pdf}
\alias{landau_lpdf}
\alias{landau_cdf}
\alias{landau_lcdf}
\alias{landau_quantile}
\title{Landau Distribution Functions}
\usage{
landau_distribution(location = 0, scale = 1)

landau_pdf(x, location = 0, scale = 1)

landau_lpdf(x, location = 0, scale = 1)

landau_cdf(x, location = 0, scale = 1)

landau_lcdf(x, location = 0, scale = 1)

landau_quantile(p, location = 0, scale = 1)
}
\arguments{
\item{location}{location parameter (default is 0)}

\item{scale}{scale parameter (default is 1)}

\item{x}{quantile}

\item{p}{probability (0 <= p <= 1)}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the Landau distribution.
}
\examples{
# Landau distribution with location 0 and scale 1
dist <- landau_distribution(0, 1)
# Apply generic functions
cdf(dist, 0.5)
logcdf(dist, 0.5)
pdf(dist, 0.5)
logpdf(dist, 0.5)
hazard(dist, 0.5)
chf(dist, 0.5)
median(dist)
mode(dist)
range(dist)
quantile(dist, 0.2)
support(dist)

# Convenience functions
landau_pdf(3)
landau_lpdf(3)
landau_cdf(3)
landau_lcdf(3)
landau_quantile(0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/landau_dist.html}{Boost Documentation} for more details on the mathematical background.
}
