% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reference_values.R
\name{bodycomp_reference}
\alias{bodycomp_reference}
\title{Get body composition reference values}
\usage{
bodycomp_reference(
  metric,
  sex,
  level,
  age,
  type,
  measurement = NULL,
  percentile = NULL,
  z_score = NULL,
  verbose = FALSE,
  digits = 2
)
}
\arguments{
\item{metric}{character (vector), body composition metric.}

\item{sex}{character (vector), ""Female" or "Male"}

\item{level}{character (vector), used vertebral level}

\item{age}{integer (vector), age}

\item{type}{character, type of value to return, either of "percentile", "z_score", "reference_value", "percent_predicted"}

\item{measurement}{numeric (vector), raw value of measurement}

\item{percentile}{numeric (vector), percentile to return value for. If both percentile and z_score are given, only percentile is evaluated}

\item{z_score}{numeric (vector), z score to return value for. If both percentile and z_score are given, only percentile is evaluated}

\item{verbose}{logical, should messages be displayed}

\item{digits}{integer, digits to round return value to}
}
\value{
numeric, corresponding percentile
}
\description{
For a given constellation of metric, sex, vertebral level, and age returns either
 - the reference percentile
 - the reference z-score
 - the reference value
 - the percent of predicted value
}
\details{
Reference models are available for the following metrics:
   - CSMA: Cross-sectional muscle area [cm²]
   - SMI: Skeletal Muscle Index [cm²/m²]
   - SMRA: Skeletal Muscle Radioattenuation [Hounsfield Units (HU)]
   - SMG: Skeletal Muscle Gauge [cm² * HU/ m²]
   - CSFA: Cross-sectional (subcutaneous) fat area [cm²]
   - SATI: Subcutaneous Adipose Tissue Index [cm²/m²]
   - SATRA: Subcutaneous Adipose Tissue Radioattenuation [HU]
   - SATG: Subcutaneous Adipose Tissue Gauge [cm² * HU/ m²]
   - CSVFA: Cross-sectional Visceral Fat Area [cm²]
   - VATI: Visceral Adipose Tissue Index [cm²/m²]
   - VATRA: Visceral Adipose Tissue Radioattenuation [HU]
   - VATG: Visceral Adipose Tissue Gauge [cm² * HU/ m²]
   - TAT: Cross-sectional Total Adipose Tissue Area [cm²] (SATA + VATA)
   - TATI: Total Adipose Tissue Index [cm²/m²] (SATI + VATI)
   - VAT_SAT_ratio: VAT/SAT ratio []

 Measurement values must be >= -124 for SATRA and VATRA, <= -1 for SATG and VATG, and >= 1 for all other metrics.

 The reference values are based on LMSP models constructed from the Framingham Heart Study published in the following publications:
   - Marquardt JP, Tonnesen PE, Mercaldo ND, Graur A, Allaire B, Bouxsein ML, Samelson EJ, Kiel DP, Fintelmann FJ.
     Subcutaneous and Visceral adipose tissue Reference Values from Framingham Heart Study Thoracic and Abdominal CT.
     Investigative Radiology, 2024.
   - Tonnesen PE, Mercaldo ND, Tahir I, Dietrich ASW, Amari W, Graur A, Allaire B, Bouxsein ML, Samelson EJ, Kiel DP, Fintelmann FJ.
     Muscle Reference Values from Thoracic and Abdominal CT for Sarcopenia Assessment: The Framingham Heart Study.
     Investigative Radiology, 2023.
}
\examples{
\dontshow{if (requireNamespace("adiposerefdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bodycomp_reference(metric=c("CSFA", "CSFA"), sex=c("Female","Male"),
                  level=c("T5","L3"), age=c(42,68), measurement=c(100,200),
                  type = "percentile")

\dontshow{\}) # examplesIf}
}
\author{
J. Peter Marquardt
}
