% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sniff_key_route.R
\name{sniff_key_route}
\alias{sniff_key_route}
\title{Identify Key Routes in Citation Networks}
\usage{
sniff_key_route(network, scope = "network", citations_percentage = 1)
}
\arguments{
\item{network}{A network object of class \code{tbl_graph} or \code{igraph} containing
citation data, or a list object generated by \code{sniff_groups()} when
\code{scope = "groups"}}

\item{scope}{Character string specifying the analysis scope. Must be either
"network" (for full network analysis) or "groups" (for group-wise analysis
of a grouped network)}

\item{citations_percentage}{Numeric value between 0 and 1 indicating the
percentage of top SPC edges eligible for the key-route path.
Default is 1 (all edges)}
}
\value{
A list containing for each group:
\itemize{
\item \code{plot} - A ggplot2 object visualizing the key citation route
\item \code{data} - A tibble with publication details (name, TI, AU, PY)
of nodes in the key route
}
}
\description{
This function identifies and visualizes key citation routes within scientific
networks by analyzing the most significant citation paths between publications.
The algorithm implements the key-route search from the integrated main path
analysis approach described in Liu & Lu (2012).
}
\details{
The function implements the key-route search from Liu & Lu (2012):
\enumerate{
\item Computes Search Path Count (SPC) for each citation link using an
efficient O(V+E) algorithm based on topological sort. SPC measures
how many source-to-sink paths traverse each link.
\item Selects the key-route: the link with the highest SPC value.
\item Searches forward from the end node of the key-route, greedily
following the outgoing link with the highest SPC, until a sink is reached.
\item Searches backward from the start node of the key-route, greedily
following the incoming link with the highest SPC, until a source is reached.
}

The SPC is computed as \code{forward[u] * backward[v]} for each edge (u, v),
where \code{forward[u]} counts paths from any source to u and \code{backward[v]}
counts paths from v to any sink (Batagelj, 2003). This guarantees the most
significant link is always included in the key-route path.
}
\examples{
\dontrun{
# Example with network scope
result <- sniff_key_route(my_network, scope = "network", citations_percentage = 0.8)

# Example with groups scope
grouped_network <- sniff_groups(data)
result <- sniff_key_route(grouped_network, scope = "groups")

# Access results for a specific group
result$group_name$plot
result$group_name$data
}

}
\references{
Liu JS, Lu LYY. An integrated approach for main path analysis: Development
of the Hirsch index as an example. Journal of the American Society for
Information Science and Technology. 2012;63(3):528-542.
\doi{10.1002/asi.21692}

Batagelj V. Efficient algorithms for citation network analysis.
University of Ljubljana, Institute of Mathematics, Physics and Mechanics,
Department of Theoretical Computer Science, Preprint Series. 2003;41:897.
}
