% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajectories_core.R
\name{build_temporal_dag}
\alias{build_temporal_dag}
\title{Build temporal directed acyclic graph from trajectory data}
\usage{
build_temporal_dag(
  groups_cumulative_trajectories,
  group,
  jaccard_min = 0.05,
  intra_min = 0.1,
  k_out = 2
)
}
\arguments{
\item{groups_cumulative_trajectories}{List with \code{groups_similarity} and
\code{groups_attributes} components}

\item{group}{Character ID of the group to process (e.g., "component1_g01")}

\item{jaccard_min}{Minimum Jaccard similarity for edges (default: 0.05)}

\item{intra_min}{Minimum proportion of tracked documents within group for
nodes (default: 0.10)}

\item{k_out}{Maximum number of outgoing edges to keep per node (default: 2)}
}
\value{
An igraph object representing the temporal DAG
}
\description{
Constructs a DAG from group trajectory data by filtering edges based on
Jaccard similarity and node attributes, then keeping only the strongest
outgoing connections per node.
}
\keyword{internal}
