% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomod2_classes_1.R
\docType{class}
\name{BIOMOD.formated.data.PA}
\alias{BIOMOD.formated.data.PA}
\alias{BIOMOD.formated.data.PA-class}
\alias{BIOMOD.formated.data.PA,numeric,data.frame-method}
\alias{BIOMOD.formated.data.PA,numeric,SpatRaster-method}
\title{\code{BIOMOD_FormatingData()} output object class (with pseudo-absences)}
\usage{
\S4method{BIOMOD.formated.data.PA}{numeric,data.frame}(
  sp,
  env,
  xy = NULL,
  dir.name = ".",
  sp.name = NULL,
  eval.sp = NULL,
  eval.env = NULL,
  eval.xy = NULL,
  PA.nb.rep = 1,
  PA.strategy = "random",
  PA.nb.absences = NULL,
  PA.dist.min = 0,
  PA.dist.max = NULL,
  PA.sre.quant = 0.025,
  PA.fact.aggr = NULL,
  PA.user.table = NULL,
  na.rm = TRUE,
  filter.raster = FALSE,
  seed.val = NULL
)

\S4method{BIOMOD.formated.data.PA}{numeric,SpatRaster}(
  sp,
  env,
  xy = NULL,
  dir.name = ".",
  sp.name = NULL,
  eval.sp = NULL,
  eval.env = NULL,
  eval.xy = NULL,
  PA.nb.rep = 1,
  PA.strategy = "random",
  PA.nb.absences = NULL,
  PA.dist.min = 0,
  PA.dist.max = NULL,
  PA.sre.quant = 0.025,
  PA.fact.aggr = NULL,
  PA.user.table = NULL,
  na.rm = TRUE,
  filter.raster = FALSE,
  seed.val = NULL
)
}
\arguments{
\item{sp}{a \code{vector}, a \code{\link[terra:vect]{SpatVector}} without associated 
data (\emph{if presence-only}), or a \code{\link[terra:vect]{SpatVector}}
object containing binary data (\code{0} : absence,  \code{1} : presence,
\code{NA} : indeterminate) for a single species that will be used to 
build the species distribution model(s)
\cr \emph{Note that old format from \pkg{sp} are still supported such as
 \code{SpatialPoints}  (if presence-only) or \code{SpatialPointsDataFrame}
 object containing binary data.}}

\item{env}{a \code{matrix}, \code{data.frame}, \code{\link[terra:vect]{SpatVector}}
or \code{\link[terra:rast]{SpatRaster}} object containing the explanatory variables 
(in columns or layers) that will be used to build the species distribution model(s).
\cr \emph{Note that old format from \pkg{raster} and \pkg{sp} are still supported such as 
\code{RasterStack} and \code{SpatialPointsDataFrame} objects. }}

\item{xy}{(\emph{optional, default} \code{NULL}) \cr 
If \code{resp.var} is a \code{vector}, a 2-columns \code{matrix} or \code{data.frame} 
containing the corresponding \code{X} and \code{Y} coordinates that will be used to build the 
species distribution model(s)}

\item{dir.name}{a \code{character} corresponding to the modeling folder}

\item{sp.name}{a \code{character} corresponding to the species name}

\item{eval.sp}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector}, a \code{\link[terra:vect]{SpatVector}} without associated 
data (\emph{if presence-only}), or a \code{\link[terra:vect]{SpatVector}}
object containing binary data (\code{0} : absence, \code{1} : presence, 
\code{NA} : indeterminate) for a single species that will be used to
evaluate the species distribution model(s) with independent data
\cr \emph{Note that old format from \pkg{sp} are still supported such as
\code{SpatialPoints}  (if presence-only) or \code{SpatialPointsDataFrame}
object containing binary data.}}

\item{eval.env}{(\emph{optional, default} \code{NULL}) \cr 
A \code{matrix}, \code{data.frame}, \code{\link[terra:vect]{SpatVector}} or
\code{\link[terra:rast]{SpatRaster}} object containing the explanatory
variables (in columns or layers) that will be used to evaluate the species
distribution model(s) with independent data
\cr \emph{Note that old format from \pkg{raster} and \pkg{sp} are still
supported such as \code{RasterStack} and \code{SpatialPointsDataFrame}
objects. }}

\item{eval.xy}{(\emph{optional, default} \code{NULL}) \cr 
If \code{resp.var} is a \code{vector}, a 2-columns \code{matrix} or
\code{data.frame} containing the corresponding \code{X} and \code{Y}
coordinates that will be used to evaluate the species distribution model(s)
with independent data}

\item{PA.nb.rep}{(\emph{optional, default} \code{0}) \cr 
If pseudo-absence selection, an \code{integer} corresponding to the number of sets 
(repetitions) of pseudo-absence points that will be drawn}

\item{PA.strategy}{(\emph{optional, default} \code{NULL}) \cr 
If pseudo-absence selection, a \code{character} defining the strategy that will be used to 
select the pseudo-absence points. Must be \code{random}, \code{sre}, \code{disk} or 
\code{user.defined} (see Details)}

\item{PA.nb.absences}{(\emph{optional, default} \code{0}) \cr 
If pseudo-absence selection, and \code{PA.strategy = 'random'} or \code{PA.strategy = 'sre'} 
or \code{PA.strategy = 'disk'}, an \code{integer} (or a \code{vector} of \code{integer} the 
same size as \code{PA.nb.rep}) corresponding to the number of pseudo-absence points that 
will be selected for each pseudo-absence repetition (true absences included)}

\item{PA.dist.min}{(\emph{optional, default} \code{0}) \cr 
If pseudo-absence selection and \code{PA.strategy = 'disk'}, a \code{numeric} defining the 
minimal distance to presence points used to make the \code{disk} pseudo-absence selection 
(in the same projection system units as \code{coord}, see Details)}

\item{PA.dist.max}{(\emph{optional, default} \code{0}) \cr 
If pseudo-absence selection and \code{PA.strategy = 'disk'}, a \code{numeric} defining the 
maximal distance to presence points used to make the \code{disk} pseudo-absence selection 
(in the same projection system units as \code{coord}, see Details)}

\item{PA.sre.quant}{(\emph{optional, default} \code{0}) \cr 
If pseudo-absence selection and \code{PA.strategy = 'sre'}, a \code{numeric} between \code{0} 
and \code{0.5} defining the half-quantile used to make the \code{sre} pseudo-absence selection 
(see Details)}

\item{PA.fact.aggr}{(\emph{optional, default} \code{NULL}) \cr
If \code{strategy = 'random'} or \code{strategy = 'disk'}, a \code{integer} defining the factor of aggregation to reduce the resolution}

\item{PA.user.table}{(\emph{optional, default} \code{NULL}) \cr 
If pseudo-absence selection and \code{PA.strategy = 'user.defined'}, a \code{matrix} or 
\code{data.frame} with as many rows as \code{resp.var} values, as many columns as 
\code{PA.nb.rep}, and containing \code{TRUE} or \code{FALSE} values defining which points 
will be used to build the species distribution model(s) for each repetition (see Details)}

\item{na.rm}{(\emph{optional, default} \code{TRUE}) \cr 
A \code{logical} value defining whether points having one or several missing
values for explanatory variables should be removed from the analysis or not}

\item{filter.raster}{(\emph{optional, default} \code{FALSE}) \cr 
If \code{env} is of raster type, a \code{logical} value defining whether \code{sp} 
is to be filtered when several points occur in the same raster cell}

\item{seed.val}{(\emph{optional, default} \code{NULL}) \cr 
An \code{integer} value corresponding to the new seed value to be set}
}
\description{
Class returned by \code{\link{BIOMOD_FormatingData}}, and used by 
\code{\link{bm_Tuning}}, \code{\link{bm_CrossValidation}} and 
\code{\link{BIOMOD_Modeling}}
}
\section{Slots}{

\describe{
\item{\code{dir.name}}{a \code{character} corresponding to the modeling folder}

\item{\code{sp.name}}{a \code{character} corresponding to the species name}

\item{\code{coord}}{a 2-columns \code{data.frame} containing the corresponding \code{X} and \code{Y} 
coordinates}

\item{\code{data.species}}{a \code{vector} containing the species observations (\code{0}, \code{1} or 
\code{NA})}

\item{\code{data.env.var}}{a \code{data.frame} containing explanatory variables}

\item{\code{data.mask}}{a \code{\link[terra:rast]{SpatRaster}} object containing 
the mask of the studied area}

\item{\code{has.data.eval}}{a \code{logical} value defining whether evaluation data is given}

\item{\code{eval.coord}}{(\emph{optional, default} \code{NULL}) \cr 
A 2-columns \code{data.frame} containing the corresponding \code{X} and \code{Y} 
coordinates for evaluation data}

\item{\code{eval.data.species}}{(\emph{optional, default} \code{NULL}) \cr 
A \code{vector} containing the species observations (\code{0}, \code{1} or \code{NA}) for 
evaluation data}

\item{\code{eval.data.env.var}}{(\emph{optional, default} \code{NULL}) \cr 
A \code{data.frame} containing explanatory variables for evaluation data}

\item{\code{PA.strategy}}{a \code{character} corresponding to the pseudo-absence selection strategy}

\item{\code{PA.table}}{a \code{data.frame} containing the corresponding table of selected 
pseudo-absences (indicated by \code{TRUE} or \code{FALSE}) from the \code{pa.tab} list 
element returned by the \code{\link{bm_PseudoAbsences}} function}
}}

\examples{
showClass("BIOMOD.formated.data.PA")

## ----------------------------------------------------------------------- #
library(terra)

# Load species occurrences (6 species available)
data(DataSpecies)
head(DataSpecies)

# Select the name of the studied species
myRespName <- 'GuloGulo'

# Keep only presence informations
DataSpecies <- DataSpecies[which(DataSpecies[, myRespName] == 1), ]

# Get corresponding presence/absence data
myResp <- as.numeric(DataSpecies[, myRespName])

# Get corresponding XY coordinates
myRespXY <- DataSpecies[, c('X_WGS84', 'Y_WGS84')]

# Load environmental variables extracted from BIOCLIM (bio_3, bio_4, bio_7, bio_11 & bio_12)
data(bioclim_current)
myExpl <- terra::rast(bioclim_current)

\dontshow{
myExtent <- terra::ext(0,30,45,70)
myExpl <- terra::crop(myExpl, myExtent)
}

## ----------------------------------------------------------------------- #
# Format Data with pseudo-absences : random method
myBiomodData <- BIOMOD_FormatingData(resp.name = myRespName,
                                     resp.var = myResp,
                                     resp.xy = myRespXY,
                                     expl.var = myExpl,
                                     PA.nb.rep = 4,
                                     PA.strategy = 'random',
                                     PA.nb.absences = 1000)
myBiomodData
plot(myBiomodData)


}
\seealso{
\code{\link{BIOMOD_FormatingData}}, \code{\link{bm_PseudoAbsences}}, 
\code{\link{bm_Tuning}}, \code{\link{bm_CrossValidation}}, 
\code{\link{BIOMOD_Modeling}}, \code{\link{bm_RunModelsLoop}}

Other Toolbox objects: 
\code{\link{BIOMOD.ensemble.models.out}},
\code{\link{BIOMOD.formated.data}},
\code{\link{BIOMOD.models.options}},
\code{\link{BIOMOD.models.out}},
\code{\link{BIOMOD.options.dataset}},
\code{\link{BIOMOD.options.default}},
\code{\link{BIOMOD.projection.out}},
\code{\link{BIOMOD.rangesize.out}},
\code{\link{BIOMOD.stored.data}},
\code{\link{biomod2_ensemble_model}},
\code{\link{biomod2_model}}
}
\author{
Damien Georges
}
\concept{Toolbox objects}
