% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initial_guesses.R
\name{check_growth_guess}
\alias{check_growth_guess}
\title{Visual check of an initial guess of the model parameters}
\usage{
check_growth_guess(
  fit_data,
  model_keys,
  guess,
  environment = "constant",
  env_conditions = NULL,
  approach = "single",
  logbase_mu = 10,
  formula = logN ~ time
)
}
\arguments{
\item{fit_data}{Tibble (or data.frame) of data for the fit. It must have two columns, one with
the elapsed time (\code{time} by default) and another one with the decimal logarithm
of the populatoin size (\code{logN} by default). Different column names can be
defined using the \code{formula} argument.}

\item{model_keys}{Named the equations of the secondary model as in \code{\link[=fit_growth]{fit_growth()}}}

\item{guess}{Named vector with the initial guess of the model parameters as in \code{\link[=fit_growth]{fit_growth()}}}

\item{environment}{type of environment. Either "constant" (default) or "dynamic" (see below for details
on the calculations for each condition)}

\item{env_conditions}{Tibble describing the variation of the environmental
conditions for dynamic experiments. See \code{\link[=fit_growth]{fit_growth()}}. Ignored when \code{environment = "constant"}}

\item{approach}{whether "single" (default) or "global". Please see \code{\link[=fit_growth]{fit_growth()}} for details.``}

\item{logbase_mu}{Base of the logarithm the growth rate is referred to.
By default, 10 (i.e. log10). See vignette about units for details.}

\item{formula}{an object of class "formula" describing the x and y variables.
\code{logN ~ time} as a default.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} comparing the model prediction against the data
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Generates a plot comparing a set of data points against the model prediction
corresponding to an initial guess of the model parameters
}
\examples{

## Examples under constant environmental conditions -------------------------

## We need some data

my_data <- data.frame(time = 0:9,
                      logN = c(2, 2.1, 1.8, 2.5, 3.1, 3.4, 4, 4.5, 4.8, 4.7)
                      )
                      
## We can directly plot the comparison for some values

check_growth_guess(my_data, list(primary = "modGompertz"),
                   c(logN0 = 1.5, mu = .8, lambda = 4, C = 3)
                   )
                   
## Ot it can be combined with the automatic initial guess

check_growth_guess(my_data, list(primary = "modGompertz"),
                   make_guess_primary(my_data, "modGompertz")
                   )
                   
## Examples under dynamic environmental conditions --------------------------

## We will use the datasets included in the package

data("example_dynamic_growth")
data("example_env_conditions")

## Model equations are assigned as in fit_growth

sec_models <- list(temperature = "CPM", aw = "CPM")

## Guesses of model parameters are also defined as in fit_growth

guess <- list(Nmax = 1e4, 
              N0 = 1e0, Q0 = 1e-3,
              mu_opt = 4, 
              temperature_n = 1,
              aw_xmax = 1, aw_xmin = .9, aw_n = 1,
              temperature_xmin = 25, temperature_xopt = 35,
              temperature_xmax = 40, aw_xopt = .95
              )
              
## We can now check our initial guess

check_growth_guess(example_dynamic_growth, sec_models, guess,
                   "dynamic",
                   example_env_conditions)

}
