% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_audit.R
\name{plot_perm_distribution}
\alias{plot_perm_distribution}
\title{Plot permutation distribution for a LeakAudit object}
\usage{
plot_perm_distribution(audit)
}
\arguments{
\item{audit}{LeakAudit.}
}
\value{
A list containing the observed value, permuted mean, permutation values,
  and a ggplot object.
}
\description{
Visualizes the label-permutation metric distribution and marks the observed
and permuted-mean values to help assess leakage signals. Requires ggplot2.
}
\examples{
if (requireNamespace("ggplot2", quietly = TRUE)) {
  set.seed(42)
  df <- data.frame(
    subject = rep(1:15, each = 2),
    outcome = factor(rep(c(0, 1), 15)),
    x1 = rnorm(30),
    x2 = rnorm(30)
  )
  splits <- make_split_plan(df, outcome = "outcome",
                            mode = "subject_grouped", group = "subject",
                            v = 3, progress = FALSE)
  custom <- list(
    glm = list(
      fit = function(x, y, task, weights, ...) {
        stats::glm(y ~ ., data = as.data.frame(x),
                   family = stats::binomial(), weights = weights)
      },
      predict = function(object, newdata, task, ...) {
        as.numeric(stats::predict(object, newdata = as.data.frame(newdata),
                                  type = "response"))
      }
    )
  )
  fit <- fit_resample(df, outcome = "outcome", splits = splits,
                      learner = "glm", custom_learners = custom,
                      metrics = "auc", refit = FALSE, seed = 1)
  audit <- audit_leakage(fit, metric = "auc", B = 20)
  plot_perm_distribution(audit)
}

}
