% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin2norm.R
\name{estimate_multiThresh_MLE}
\alias{estimate_multiThresh_MLE}
\title{MLE with Numeric Integration (Multiple Thresholds per Study)}
\usage{
estimate_multiThresh_MLE(data_list, gh_points = 20)
}
\arguments{
\item{data_list}{A list with:
\itemize{
\item \code{n_i}: numeric vector (length I)
\item \code{c_ij}: list of length I
\item \code{p_ij_obs}: list of length I
}}

\item{gh_points}{integer; number of Gauss-Hermite points (default 12).}
}
\value{
A list with \code{mu0}, \code{sigma}, \code{tau}, \code{method="MLE_integration"}.
}
\description{
Each study \eqn{i} has thresholds \eqn{\{c_{ij}\}}, each with an observed proportion
\eqn{p_{ij}^{obs}}. We assume \eqn{\mu_i \sim \mathcal{N}(\mu_0,\tau^2)} and
\eqn{X_{ij} \sim \mathcal{N}(\mu_i,\sigma^2)}. The log-likelihood integrates out
\eqn{\mu_i} via Gauss-Hermite quadrature.
}
