% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blas_extras.R
\name{dset}
\alias{dset}
\title{Fill a vector or matrix with a constant value}
\usage{
dset(N = NULL, ALPHA, X, INCX = 1L)
}
\arguments{
\item{N}{Optional integer specifying the number of elements to modify. Defaults to the length of `X`.}

\item{ALPHA}{Numeric scalar used to populate `X`.}

\item{X}{Double-precision vector, matrix or [`bigmemory::big.matrix`] to be filled in place.}

\item{INCX}{Integer stride between successive elements of `X`.}
}
\value{
Invisibly returns `X` after modification.
}
\description{
Fill a vector or matrix with a constant value
}
\examples{
x <- matrix(0, 2, 3)
dset(ALPHA = 5, X = x)
x

}
